/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.tags.filters;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Optional;
import java.util.function.Predicate;
import org.openstreetmap.atlas.exception.CoreException;
import org.openstreetmap.atlas.tags.Taggable;
import org.openstreetmap.atlas.tags.filters.TaggableFilter;
import org.openstreetmap.atlas.utilities.collections.StringList;
import org.openstreetmap.atlas.utilities.conversion.TwoWayConverter;

public class LineFilterConverter
implements TwoWayConverter<String, TaggableFilter> {
    private static final String VALUES_SEPARATOR = ",";
    private static final String KEY_VALUE_SEPARATOR = "->";
    private static final Predicate<Taggable> ALL_VALID = taggable -> true;

    @Override
    public String backwardConvert(TaggableFilter object) {
        return this.backwardConvert(object, 0);
    }

    @Override
    public TaggableFilter convert(String object) {
        return this.convert(object, TaggableFilter.TreeBoolean.OR, 0);
    }

    private String backwardConvert(TaggableFilter object, int numberOfOccurrences) {
        Optional<String> definition = object.getDefinition();
        if (definition.isPresent()) {
            return definition.get();
        }
        int numberOfSeparators = this.numberOfSeparators(numberOfOccurrences);
        String separatorCharacter = object.getTreeBoolean().separator();
        StringList separatorList = new StringList();
        for (int i = 0; i < numberOfSeparators; ++i) {
            separatorList.add(separatorCharacter);
        }
        String separator = separatorList.join("");
        StringList result = new StringList();
        object.getChildren().forEach(child -> result.add(this.backwardConvert((TaggableFilter)child, numberOfOccurrences + 1)));
        return result.join(separator);
    }

    private TaggableFilter convert(String object, TaggableFilter.TreeBoolean treeBoolean, int numberOfOccurrences) {
        String regex = this.regex(treeBoolean.separator(), this.numberOfSeparators(numberOfOccurrences));
        StringList split = StringList.splitByRegex(object, regex);
        ArrayList<TaggableFilter> children = new ArrayList<TaggableFilter>();
        if (split.size() > 1) {
            for (String value : split) {
                children.add(this.convert(value, treeBoolean.other(), numberOfOccurrences + 1));
            }
            return new TaggableFilter(children, treeBoolean);
        }
        if (object.contains(treeBoolean.other().separator())) {
            children.add(this.convert(object, treeBoolean.other(), numberOfOccurrences + 1));
            return new TaggableFilter(children, treeBoolean);
        }
        String definition = split.get(0);
        Predicate<Taggable> simple = this.simple(definition);
        return new TaggableFilter(simple, definition);
    }

    private String escaped(String value) {
        if (TaggableFilter.TreeBoolean.OR.separator().equals(value)) {
            return "\\" + TaggableFilter.TreeBoolean.OR.separator();
        }
        return value;
    }

    private int numberOfSeparators(int numberOfOccurrences) {
        return numberOfOccurrences / 2 + 1;
    }

    private String regex(String character, int numberOfOccurrences) {
        if (numberOfOccurrences < 1) {
            throw new CoreException("Invalid number of occurences for pattern with {}: {}", character, numberOfOccurrences);
        }
        String escapedCharacter = this.escaped(character);
        String negativeLookBefore = "(?<!" + escapedCharacter + ")";
        String characterTimesNumber = escapedCharacter + "{" + numberOfOccurrences + "}";
        if ("\\|{2}".equals(characterTimesNumber)) {
            characterTimesNumber = "(" + characterTimesNumber + "|\\^)";
        }
        String negativeLookAhead = "(?!" + escapedCharacter + ")";
        return negativeLookBefore + characterTimesNumber + negativeLookAhead;
    }

    private Predicate<Taggable> simple(String simple) {
        if ("".equals(simple)) {
            return ALL_VALID;
        }
        StringList split = StringList.split(simple, KEY_VALUE_SEPARATOR);
        if (split.size() != 2) {
            throw new CoreException("Taggable filter definition \"{}\" is invalid.", simple);
        }
        String key = split.get(0);
        StringList values = StringList.split(split.get(1), VALUES_SEPARATOR);
        return (Predicate<Taggable> & Serializable)taggable -> taggable.containsValue(key, values);
    }
}

