/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.tags;

import java.util.Arrays;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.openstreetmap.atlas.exception.CoreException;
import org.openstreetmap.atlas.locale.IsoLanguage;
import org.openstreetmap.atlas.tags.LocalizedTagNameWithOptionalDate;
import org.openstreetmap.atlas.tags.annotations.validation.Validators;
import org.openstreetmap.atlas.utilities.collections.Maps;
import org.openstreetmap.osmosis.core.domain.v0_6.Tag;

public interface Taggable {
    public static Taggable with(Collection<Tag> tagCollection) {
        HashMap<String, String> tags = new HashMap<String, String>();
        tagCollection.forEach(tag -> tags.put(tag.getKey(), tag.getValue()));
        return Taggable.with(tags);
    }

    public static Taggable with(final Map<String, String> tags) {
        return new Taggable(){

            @Override
            public Optional<String> getTag(String key) {
                return Optional.ofNullable(tags.get(key));
            }

            public String toString() {
                return tags.toString();
            }
        };
    }

    public static Taggable with(String ... tags) {
        return Taggable.with(Maps.hashMap(tags));
    }

    default public boolean containsValue(String key, Iterable<String> matches) {
        Optional<String> valueOption = this.getTag(key);
        if (valueOption.isPresent()) {
            String value = valueOption.get();
            for (String candidate : matches) {
                if (candidate.startsWith("!")) {
                    if (candidate.length() > 1) {
                        String forbiddenValue = candidate.substring(1);
                        return !value.equalsIgnoreCase(forbiddenValue);
                    }
                    return false;
                }
                if ("*".equals(candidate) || value.equalsIgnoreCase(candidate)) {
                    return true;
                }
                if (candidate != null && candidate.startsWith("*") && value.endsWith(candidate.substring(1))) {
                    return true;
                }
                if (candidate == null || !candidate.endsWith("*") || !value.startsWith(candidate.substring(0, candidate.length() - 1))) continue;
                return true;
            }
        } else {
            for (String candidate : matches) {
                if (candidate.startsWith("!")) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    default public Optional<String> getTag(Class<?> key, Optional<IsoLanguage> language, TagSearchOption ... searchOptions) {
        EnumSet<TagSearchOption> searchOptionSet = searchOptions.length > 0 ? EnumSet.copyOf(Arrays.asList(searchOptions)) : EnumSet.noneOf(TagSearchOption.class);
        Optional<String> localizedKeyName = Validators.localizeKeyName(key, language, searchOptions);
        if (localizedKeyName.isPresent()) {
            Optional<String> localizedValue = this.getTag(localizedKeyName.get());
            if (localizedValue.isPresent() || searchOptionSet.contains((Object)TagSearchOption.LOCALIZED_ONLY) || searchOptionSet.contains((Object)TagSearchOption.FORCE_ALL_LOCALIZED_ONLY)) {
                return localizedValue;
            }
            return this.getTag(Validators.localizeKeyName(key, Optional.empty(), new TagSearchOption[0]).get());
        }
        return Optional.empty();
    }

    public Optional<String> getTag(String var1);

    default public Map<String, String> getTags() {
        return new HashMap<String, String>();
    }

    default public Map<String, String> getTags(Predicate<String> filter) {
        return this.getTags().entrySet().stream().filter(item -> filter.test((String)item.getKey())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    default public boolean hasAtLeastOneOf(Map<String, String> tags) {
        for (String key : tags.keySet()) {
            String value = tags.get(key);
            Optional<String> myValue = this.getTag(key);
            if (!myValue.isPresent()) continue;
            if ("*".equals(value)) {
                return true;
            }
            if (!value.equals(myValue.get())) continue;
            return true;
        }
        return false;
    }

    default public Optional<Set<IsoLanguage>> languagesFor(Class<?> tag, TagSearchOption ... searchOptions) {
        EnumSet<TagSearchOption> searchOptionSet;
        TreeSet returnValue = new TreeSet();
        EnumSet<TagSearchOption> enumSet = searchOptionSet = searchOptions.length > 0 ? EnumSet.copyOf(Arrays.asList(searchOptions)) : EnumSet.noneOf(TagSearchOption.class);
        if (!searchOptionSet.contains((Object)TagSearchOption.FORCE_ALL_LOCALIZED_ONLY) && !Validators.hasLocalizedTagKey(tag)) {
            throw new CoreException("{} isn't a localizable tag", tag.getName());
        }
        String prefix = Validators.TagKeySearch.findTagKeyIn(tag).get().getKeyName();
        int prefixLength = prefix.length();
        for (String key : this.getTags().keySet()) {
            if (!key.startsWith(prefix) || key.length() <= prefixLength) continue;
            LocalizedTagNameWithOptionalDate parser = new LocalizedTagNameWithOptionalDate(key);
            parser.getLanguage().ifPresent(language -> returnValue.add(language));
        }
        return Optional.of(returnValue);
    }

    default public String tag(String key) {
        return this.getTag(key).orElse(null);
    }

    public static enum TagSearchOption {
        DEFAULT,
        LOCALIZED_ONLY,
        FORCE_ALL_LOCALIZED_ONLY;

    }
}

