/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.tags;

import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import org.openstreetmap.atlas.tags.Taggable;
import org.openstreetmap.atlas.tags.annotations.Tag;
import org.openstreetmap.atlas.tags.annotations.TagKey;
import org.openstreetmap.atlas.utilities.tuples.Tuple;

@Tag(synthetic=true, value=Tag.Validation.NON_EMPTY_STRING)
public interface SyntheticRelationRoleUpdated {
    @TagKey
    public static final String KEY = "synthetic_relation_role_updated";
    public static final String ROLE_CHANGE_IDENTIFIER_DELIMITER = "|";

    public static Optional<Tuple<Long, RoleChange>> all(Taggable taggable) {
        Optional<String> possibleUpdatedRole = taggable.getTag(SyntheticRelationRoleUpdated.class, Optional.empty(), new Taggable.TagSearchOption[0]);
        if (possibleUpdatedRole.isPresent()) {
            List<String> updatedRole = Arrays.asList(possibleUpdatedRole.get().split(ROLE_CHANGE_IDENTIFIER_DELIMITER));
            return Optional.of(Tuple.createTuple(Long.valueOf(updatedRole.get(0)), RoleChange.safeValueOf(updatedRole.get(1))));
        }
        return Optional.empty();
    }

    public static boolean hasUpdatedRelationMemberRole(Taggable taggable) {
        return taggable.getTag(KEY).isPresent();
    }

    public static enum RoleChange {
        INNER_TO_OUTER,
        OUTER_TO_INNER;


        static RoleChange safeValueOf(String value) {
            try {
                return RoleChange.valueOf(value.toUpperCase());
            }
            catch (IllegalArgumentException ignored) {
                return null;
            }
        }
    }
}

