/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.tags;

import java.util.EnumSet;
import java.util.Optional;
import org.openstreetmap.atlas.tags.Taggable;
import org.openstreetmap.atlas.tags.annotations.Tag;
import org.openstreetmap.atlas.tags.annotations.TagKey;
import org.openstreetmap.atlas.tags.annotations.validation.Validators;

@Tag(taginfo="http://taginfo.openstreetmap.org/keys/oneway#values", osm="http://wiki.openstreetmap.org/wiki/Key:oneway")
public enum OneWayTag {
    YES,
    NO,
    REVERSIBLE,
    TRUE,
    FALSE,
    ONE,
    ZERO,
    MINUS_1,
    REVERSE;

    @TagKey
    public static final String KEY = "oneway";
    public static final EnumSet<OneWayTag> ONE_WAYS_FORWARD;
    public static final EnumSet<OneWayTag> ONE_WAYS_REVERSED;
    public static final EnumSet<OneWayTag> TWO_WAYS;

    public static boolean isExplicitlyTwoWay(Taggable taggable) {
        Optional<OneWayTag> oneWay = OneWayTag.tag(taggable);
        return oneWay.isPresent() && TWO_WAYS.contains((Object)oneWay.get());
    }

    public static boolean isOneWayForward(OneWayTag tag) {
        return ONE_WAYS_FORWARD.contains((Object)tag);
    }

    public static boolean isOneWayForward(Taggable taggable) {
        Optional<OneWayTag> oneWay = OneWayTag.tag(taggable);
        return oneWay.isPresent() && ONE_WAYS_FORWARD.contains((Object)oneWay.get());
    }

    public static boolean isOneWayReversed(OneWayTag tag) {
        return ONE_WAYS_REVERSED.contains((Object)tag);
    }

    public static boolean isOneWayReversed(Taggable taggable) {
        Optional<OneWayTag> oneWay = OneWayTag.tag(taggable);
        return oneWay.isPresent() && ONE_WAYS_REVERSED.contains((Object)oneWay.get());
    }

    public static boolean isOneWayReversible(OneWayTag tag) {
        return REVERSIBLE == tag;
    }

    public static boolean isOneWayReversible(Taggable taggable) {
        Optional<OneWayTag> oneWay = OneWayTag.tag(taggable);
        return oneWay.isPresent() && REVERSIBLE == oneWay.get();
    }

    public static boolean isTwoWay(OneWayTag tag) {
        return TWO_WAYS.contains((Object)tag);
    }

    public static boolean isTwoWay(Taggable taggable) {
        Optional<OneWayTag> oneWay = OneWayTag.tag(taggable);
        return !oneWay.isPresent() || TWO_WAYS.contains((Object)oneWay.get());
    }

    public static Optional<OneWayTag> tag(Taggable taggable) {
        return Validators.from(OneWayTag.class, taggable);
    }

    static {
        ONE_WAYS_FORWARD = EnumSet.of(YES, TRUE, ONE);
        ONE_WAYS_REVERSED = EnumSet.of(MINUS_1, REVERSE);
        TWO_WAYS = EnumSet.of(NO, FALSE, ZERO);
    }
}

