/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.tags;

import java.util.Optional;
import org.openstreetmap.atlas.geography.Altitude;
import org.openstreetmap.atlas.tags.Taggable;
import org.openstreetmap.atlas.tags.annotations.Tag;
import org.openstreetmap.atlas.tags.annotations.TagKey;
import org.openstreetmap.atlas.tags.annotations.validation.DoubleValidator;

@Tag(value=Tag.Validation.DOUBLE, taginfo="https://taginfo.openstreetmap.org/keys/min_height#values", osm="https://wiki.openstreetmap.org/wiki/Key:min_height")
public interface MinHeightTag {
    @TagKey
    public static final String KEY = "min_height";
    public static final DoubleValidator validator = new DoubleValidator();

    public static Optional<Altitude> get(Taggable taggable) {
        Optional<String> tagValue = taggable.getTag(KEY);
        if (tagValue.isPresent() && validator.isValid(tagValue.get())) {
            return Optional.of(Altitude.meters(Double.valueOf(tagValue.get())));
        }
        return Optional.empty();
    }
}

