/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.tags;

import java.util.Optional;
import org.openstreetmap.atlas.tags.Taggable;
import org.openstreetmap.atlas.tags.annotations.Tag;
import org.openstreetmap.atlas.tags.annotations.TagKey;
import org.openstreetmap.atlas.tags.annotations.extraction.LongExtractor;

@Tag(value=Tag.Validation.LONG, range=@Tag.Range(min=-5L, max=5L, exclude={0L}), taginfo="http://taginfo.openstreetmap.org/keys/layer#values", osm="http://wiki.openstreetmap.org/wiki/Layer")
public interface LayerTag {
    @TagKey
    public static final String KEY = "layer";

    public static long getMaxValue() {
        return LayerTag.class.getDeclaredAnnotation(Tag.class).range().max();
    }

    public static long getMinValue() {
        return LayerTag.class.getDeclaredAnnotation(Tag.class).range().min();
    }

    public static Long getTaggedOrImpliedValue(Taggable taggable, Long impliedValue) {
        Optional<Long> taggedValue = LayerTag.getTaggedValue(taggable);
        return taggedValue.isPresent() ? taggedValue.get() : impliedValue;
    }

    public static Optional<Long> getTaggedValue(Taggable taggable) {
        Optional<String> tagValue = taggable.getTag(KEY);
        if (tagValue.isPresent()) {
            LongExtractor extractor = new LongExtractor();
            return extractor.validateAndExtract(tagValue.get(), LayerTag.class.getDeclaredAnnotation(Tag.class));
        }
        return Optional.empty();
    }
}

