/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.streaming.resource.zip;

import java.io.IOException;
import java.io.InputStream;
import java.util.function.Supplier;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.openstreetmap.atlas.exception.CoreException;
import org.openstreetmap.atlas.streaming.resource.File;
import org.openstreetmap.atlas.streaming.resource.InputStreamResource;
import org.openstreetmap.atlas.streaming.resource.Resource;
import org.openstreetmap.atlas.streaming.resource.zip.ZipWritableResource;
import org.openstreetmap.atlas.utilities.collections.Iterables;

public class ZipFileWritableResource
extends ZipWritableResource {
    private static Supplier<InputStream> inputStreamSupplier(ZipFile file, ZipEntry entry) {
        return () -> {
            try {
                return file.getInputStream(entry);
            }
            catch (IOException e) {
                throw new CoreException("Cannot get the entry {}", entry.getName(), e);
            }
        };
    }

    public ZipFileWritableResource(File source) {
        super(source);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Iterable<Resource> entries() {
        try (ZipFile file = new ZipFile(this.getFileSource().getFile()){

            @Override
            public void close() {
            }
        };){
            Iterable<Resource> iterable = Iterables.translate(Iterables.from(file.entries()), entry -> new InputStreamResource(ZipFileWritableResource.inputStreamSupplier(file, entry)).withName(entry.getName()));
            return iterable;
        }
        catch (IOException e) {
            throw new CoreException("Cannot get entries from the Zipfile {}.", this.getFileSource().getName(), e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Resource entryForName(String name) {
        try (ZipFile file = new ZipFile(this.getFileSource().getFile()){

            @Override
            public void close() {
            }
        };){
            ZipEntry entry = file.getEntry(name);
            if (entry != null) {
                InputStreamResource inputStreamResource = new InputStreamResource(ZipFileWritableResource.inputStreamSupplier(file, entry)).withName(name);
                return inputStreamResource;
            }
            throw new IOException("Entry " + name + " does not exist.");
        }
        catch (IOException e) {
            throw new CoreException("Cannot get the entry {} from the Zipfile {}.", name, this.getFileSource().getName(), e);
        }
    }

    @Override
    public ZipFileWritableResource withWriteCompression(boolean compression) {
        this.setWriteCompression(compression);
        return this;
    }

    protected File getFileSource() {
        return (File)this.getWritableSource();
    }
}

