/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.streaming.resource.http;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.Optional;
import org.apache.http.Header;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.client.utils.HttpClientUtils;
import org.apache.http.impl.auth.BasicScheme;
import org.apache.http.impl.client.BasicAuthCache;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.protocol.HttpContext;
import org.openstreetmap.atlas.exception.CoreException;
import org.openstreetmap.atlas.streaming.StringInputStream;
import org.openstreetmap.atlas.streaming.resource.AbstractResource;

public abstract class HttpResource
extends AbstractResource {
    private HttpRequestBase request;
    private final URI uri;
    private CloseableHttpResponse response = null;
    private Optional<UsernamePasswordCredentials> creds = Optional.empty();
    private Optional<HttpHost> proxy = Optional.empty();

    private static HttpClientContext createBasicAuthCache(HttpHost target, HttpClientContext context) {
        BasicAuthCache authCache = new BasicAuthCache();
        BasicScheme basicAuth = new BasicScheme();
        authCache.put(target, basicAuth);
        context.setAuthCache(authCache);
        return context;
    }

    public HttpResource(String uri) {
        this(URI.create(uri));
    }

    public HttpResource(URI uri) {
        this.uri = uri;
    }

    public void close() {
        HttpClientUtils.closeQuietly(this.response);
    }

    public void execute() {
        this.response = null;
        this.onRead();
    }

    public Header[] getHeader(String headerKey) {
        this.onRead();
        return this.response.getHeaders(headerKey);
    }

    public HttpRequestBase getRequest() {
        return this.request;
    }

    public String getRequestBodyAsString() {
        StringBuilder builder = new StringBuilder();
        this.lines().forEach(x -> builder.append((String)x));
        return builder.toString();
    }

    public CloseableHttpResponse getResponse() {
        this.onRead();
        return this.response;
    }

    public int getStatusCode() {
        this.onRead();
        return this.response.getStatusLine().getStatusCode();
    }

    public URI getURI() {
        return this.uri;
    }

    public void setAuth(String user, String pass) {
        this.creds = Optional.of(new UsernamePasswordCredentials(user, pass));
    }

    public void setHeader(String name, String value) {
        this.request.setHeader(name, value);
    }

    public void setProxy(HttpHost proxy) {
        this.proxy = Optional.ofNullable(proxy);
    }

    public void setRequest(HttpRequestBase request) {
        this.request = request;
    }

    @Override
    protected InputStream onRead() {
        try {
            if (this.response == null) {
                HttpHost target = new HttpHost(this.uri.getHost(), this.uri.getPort(), this.uri.getScheme());
                HttpClientContext context = HttpClientContext.create();
                HttpClientBuilder clientBuilder = HttpClients.custom();
                if (this.creds.isPresent()) {
                    BasicCredentialsProvider credsProvider = new BasicCredentialsProvider();
                    credsProvider.setCredentials(new AuthScope(target.getHostName(), target.getPort()), this.creds.get());
                    clientBuilder = clientBuilder.setDefaultCredentialsProvider(credsProvider);
                }
                if (this.proxy.isPresent()) {
                    clientBuilder = clientBuilder.setProxy(this.proxy.get());
                }
                CloseableHttpClient client = clientBuilder.build();
                context = HttpResource.createBasicAuthCache(target, context);
                this.response = client.execute(target, (HttpRequest)this.request, (HttpContext)context);
            }
            if (this.response.getEntity() == null) {
                return new StringInputStream("");
            }
            return this.response.getEntity().getContent();
        }
        catch (IOException ioe) {
            throw new CoreException(ioe.getMessage(), ioe);
        }
    }
}

