/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.streaming.resource;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import org.openstreetmap.atlas.exception.CoreException;
import org.openstreetmap.atlas.streaming.compression.Compressor;
import org.openstreetmap.atlas.streaming.compression.Decompressor;
import org.openstreetmap.atlas.streaming.resource.AbstractWritableResource;
import org.openstreetmap.atlas.streaming.resource.FileSuffix;

public class File
extends AbstractWritableResource
implements Comparable<File> {
    private final java.io.File file;
    private String name = null;

    public static File temporary() {
        Random random = new Random();
        File result = null;
        try {
            try {
                result = new File(java.io.File.createTempFile(String.valueOf(random.nextInt(Integer.MAX_VALUE)), FileSuffix.TEMPORARY.toString()));
            }
            catch (Exception e) {
                result = new File(java.io.File.createTempFile(String.valueOf(random.nextInt(Integer.MAX_VALUE)), FileSuffix.TEMPORARY.toString()));
            }
            return result;
        }
        catch (Exception e) {
            throw new CoreException("Unable to get temporary file.", e);
        }
    }

    public static File temporary(String prefix, String suffix) {
        try {
            return new File(java.io.File.createTempFile(prefix, suffix));
        }
        catch (IOException e) {
            throw new CoreException("Unable to create a temporary file with prefix {} and suffix {}", prefix, suffix, e);
        }
    }

    public static File temporaryFolder() {
        File temporary = null;
        try {
            temporary = File.temporary();
            File parent = new File(temporary.getParent()).child(new Random().nextInt(Integer.MAX_VALUE) + "");
            parent.mkdirs();
            File file = parent;
            return file;
        }
        finally {
            temporary.delete();
        }
    }

    public File(java.io.File file) {
        this.file = file;
        if (file.getAbsolutePath().endsWith(FileSuffix.GZIP.toString())) {
            this.setCompressor(Compressor.GZIP);
            this.setDecompressor(Decompressor.GZIP);
        }
        if (this.file.getParentFile() != null) {
            this.file.getParentFile().mkdirs();
        }
    }

    public File(String path) {
        this(new java.io.File(path));
    }

    public File child(String name) {
        if (!this.file.isDirectory()) {
            throw new CoreException("Cannot create the child of a file. It has to be a folder.");
        }
        this.file.mkdirs();
        return new File(this.getAbsolutePath() + "/" + name);
    }

    @Override
    public int compareTo(File other) {
        return this.getFile().compareTo(other.getFile());
    }

    public void delete() {
        try {
            Files.delete(this.getFile().toPath());
        }
        catch (IOException e) {
            throw new CoreException("Cannot delete file", e);
        }
    }

    public void deleteRecursively() {
        Path folder = this.getFile().toPath();
        try {
            Files.walkFileTree(folder, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
                    Files.delete(dir);
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                    Files.delete(file);
                    return FileVisitResult.CONTINUE;
                }
            });
        }
        catch (IOException e) {
            throw new CoreException("Cannot delete folder recursively", e);
        }
    }

    public boolean exists() {
        return this.getFile().exists();
    }

    public String getAbsolutePath() {
        return this.file.getAbsolutePath();
    }

    public java.io.File getFile() {
        return this.file;
    }

    @Override
    public String getName() {
        if (this.name != null) {
            return this.name;
        }
        return this.file.getName();
    }

    public String getParent() {
        return this.file.getParent();
    }

    public String getPath() {
        return this.file.getPath();
    }

    public boolean isDirectory() {
        return this.file.isDirectory();
    }

    @Override
    public long length() {
        return this.file.length();
    }

    public List<File> listFilesRecursively() {
        ArrayList<File> result = new ArrayList<File>();
        if (this.getFile().isDirectory()) {
            for (java.io.File file : this.getFile().listFiles()) {
                File newFile = new File(file.getAbsolutePath());
                if (file.isDirectory()) {
                    result.addAll(newFile.listFilesRecursively());
                    continue;
                }
                result.add(newFile);
            }
        } else if (this.getFile().exists()) {
            result.add(this);
        }
        return result;
    }

    public boolean mkdirs() {
        return this.file.mkdirs();
    }

    public File parent() {
        return new File(this.file.getParent());
    }

    @Override
    public String toString() {
        return this.file.getAbsolutePath();
    }

    public File withCompressor(Compressor compressor) {
        this.setCompressor(compressor);
        return this;
    }

    public File withDecompressor(Decompressor decompressor) {
        this.setDecompressor(decompressor);
        return this;
    }

    public File withName(String name) {
        this.name = name;
        return this;
    }

    @Override
    protected InputStream onRead() {
        try {
            return new BufferedInputStream(new FileInputStream(this.file));
        }
        catch (FileNotFoundException e) {
            throw new CoreException("Cannot read file " + this.file.getPath(), e);
        }
    }

    @Override
    protected OutputStream onWrite() {
        try {
            return new BufferedOutputStream(new FileOutputStream(this.file));
        }
        catch (FileNotFoundException e) {
            throw new CoreException("Cannot write to file " + this.file.getPath(), e);
        }
    }
}

