/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.streaming.readers.json.serializers;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;
import org.openstreetmap.atlas.geography.PolyLine;
import org.openstreetmap.atlas.streaming.readers.json.converters.PolyLineCoordinateConverter;

public abstract class MultiLocationSerializer<T extends PolyLine>
implements JsonSerializer<T> {
    @Override
    public JsonElement serialize(T polyLine, Type typeOfSrc, JsonSerializationContext context) {
        JsonObject result = new JsonObject();
        result.add("type", new JsonPrimitive(this.getType()));
        polyLine.forEach(location -> {});
        result.add("coordinates", new PolyLineCoordinateConverter().convert(polyLine));
        return result;
    }

    protected abstract String getType();
}

