/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.streaming.readers.json.converters;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.openstreetmap.atlas.exception.CoreException;
import org.openstreetmap.atlas.geography.Location;
import org.openstreetmap.atlas.geography.MultiPolygon;
import org.openstreetmap.atlas.geography.PolyLine;
import org.openstreetmap.atlas.geography.Polygon;
import org.openstreetmap.atlas.streaming.readers.json.converters.PointCoordinateConverter;
import org.openstreetmap.atlas.utilities.conversion.Converter;
import org.openstreetmap.atlas.utilities.maps.MultiMap;

public class MultiPolygonCoordinateConverter
implements Converter<MultiPolygon, JsonArray> {
    private final PointCoordinateConverter coordinateConverter = new PointCoordinateConverter();

    @Override
    public JsonArray convert(MultiPolygon object) {
        JsonArray result = new JsonArray();
        object.outers().forEach(outerPolygon -> {
            JsonArray outerLocations = new JsonArray();
            outerPolygon.forEach(location -> outerLocations.add(this.coordinateConverter.convert((Location)location)));
            result.add(outerLocations);
            object.innersOf((Polygon)outerPolygon).forEach(innerPolygon -> {
                JsonArray innerLocations = new JsonArray();
                innerPolygon.forEach(location -> innerLocations.add(this.coordinateConverter.convert((Location)location)));
                result.add(innerLocations);
            });
        });
        return result;
    }

    public Converter<JsonArray, MultiPolygon> revert() {
        return jsonArray -> {
            MultiMap<Polygon, Polygon> outerToInners = new MultiMap<Polygon, Polygon>();
            jsonArray.forEach(polygon -> {
                JsonArray linearRings = (JsonArray)polygon;
                Iterator<JsonElement> linearRingsIterator = linearRings.iterator();
                if (linearRingsIterator.hasNext()) {
                    ArrayList<Polygon> polygons = new ArrayList<Polygon>();
                    while (linearRingsIterator.hasNext()) {
                        JsonArray coordinates = (JsonArray)linearRingsIterator.next();
                        ArrayList<Location> locations = new ArrayList<Location>();
                        coordinates.forEach(coordinate -> {
                            JsonArray points = (JsonArray)coordinate;
                            locations.add(this.coordinateConverter.revert().convert(points));
                        });
                        if (locations.isEmpty() || !((Location)locations.get(0)).equals(locations.get(locations.size() - 1))) {
                            throw new CoreException("Invalidly formatted Geojson Polygon within Multipolygon");
                        }
                        locations.remove(locations.size() - 1);
                        polygons.add(new Polygon((List<Location>)locations));
                    }
                    if (polygons.isEmpty()) {
                        throw new CoreException("Cannot have an empty MultiPolygon.");
                    }
                    Polygon outer = (Polygon)polygons.remove(0);
                    outerToInners.put(outer, new ArrayList());
                    polygons.forEach(inner -> {
                        if (!outer.fullyGeometricallyEncloses((PolyLine)inner)) {
                            throw new CoreException("MultiPolygon inner ring not enclosed by outer ring.");
                        }
                        outerToInners.add(outer, (Polygon)inner);
                    });
                }
            });
            if (outerToInners.isEmpty()) {
                throw new CoreException("Cannot have an empty MultiPolygon.");
            }
            return new MultiPolygon(outerToInners);
        };
    }
}

