/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.streaming.compression;

import java.io.IOException;
import java.io.InputStream;
import java.util.zip.GZIPInputStream;
import org.openstreetmap.atlas.exception.CoreException;

public interface Decompressor {
    public static final Decompressor NONE = new Decompressor(){

        @Override
        public InputStream decompress(InputStream input) {
            return input;
        }

        public String toString() {
            return "NONE";
        }
    };
    public static final Decompressor GZIP = input -> {
        try {
            return new GZIPInputStream(input);
        }
        catch (IOException e) {
            throw new CoreException("Cannot create decompressor.", e);
        }
    };

    public InputStream decompress(InputStream var1);
}

