/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.geography.sharding;

import org.openstreetmap.atlas.exception.CoreException;
import org.openstreetmap.atlas.geography.GeometricSurface;
import org.openstreetmap.atlas.geography.Location;
import org.openstreetmap.atlas.geography.PolyLine;
import org.openstreetmap.atlas.geography.sharding.Shard;
import org.openstreetmap.atlas.geography.sharding.Sharding;
import org.openstreetmap.atlas.geography.sharding.SlippyTile;
import org.openstreetmap.atlas.utilities.collections.Iterables;

public class SlippyTileSharding
implements Sharding {
    private static final long serialVersionUID = -6727830583309410676L;
    private final int zoom;

    public SlippyTileSharding(int zoom) {
        this.zoom = zoom;
    }

    public Iterable<SlippyTile> neighbors(Shard shard) {
        if (shard instanceof SlippyTile) {
            return ((SlippyTile)shard).neighbors();
        }
        throw new CoreException("Cannot have neighbors from another type of shard.");
    }

    @Override
    public Iterable<? extends Shard> shards(GeometricSurface surface) {
        return Iterables.stream(SlippyTile.allTiles(this.zoom, surface.bounds())).filter(slippyTile -> surface.overlaps(slippyTile.bounds()));
    }

    @Override
    public Iterable<? extends Shard> shardsCovering(Location location) {
        return Iterables.stream(SlippyTile.allTiles(this.zoom, location.bounds())).filter(slippyTile -> slippyTile.bounds().fullyGeometricallyEncloses(location));
    }

    @Override
    public Iterable<? extends Shard> shardsIntersecting(PolyLine polyLine) {
        return Iterables.stream(SlippyTile.allTiles(this.zoom, polyLine.bounds())).filter(slippyTile -> polyLine.intersects(slippyTile.bounds()) || slippyTile.bounds().fullyGeometricallyEncloses(polyLine));
    }

    public String toString() {
        return "slippy:" + this.zoom;
    }
}

