/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.geography.sharding;

import java.io.Serializable;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.openstreetmap.atlas.exception.CoreException;
import org.openstreetmap.atlas.geography.Located;
import org.openstreetmap.atlas.geography.Rectangle;
import org.openstreetmap.atlas.geography.sharding.Shard;
import org.openstreetmap.atlas.geography.sharding.SlippyTile;
import org.openstreetmap.atlas.utilities.collections.StringList;

public class CountryShard
implements Located,
Serializable {
    private static final long serialVersionUID = -4158215940506552768L;
    public static final String COUNTRY_SHARD_SEPARATOR = "_";
    private final Shard shard;
    private final String country;

    public static CountryShard forName(String name) {
        StringList split = StringList.split(name, COUNTRY_SHARD_SEPARATOR);
        return new CountryShard(split.get(0), SlippyTile.forName(split.get(1)));
    }

    public CountryShard(String country, Shard shard) {
        if (shard == null || country == null) {
            throw new CoreException("Cannot have null parameters: Country = {} and Shard = {}", country, shard);
        }
        this.shard = shard;
        this.country = country;
    }

    @Override
    public Rectangle bounds() {
        return this.shard.bounds();
    }

    public boolean equals(Object other) {
        if (other instanceof CountryShard) {
            CountryShard that = (CountryShard)other;
            return this.getCountry().equals(that.getCountry()) && this.getShard().equals(that.getShard());
        }
        return false;
    }

    public String getCountry() {
        return this.country;
    }

    public Shard getShard() {
        return this.shard;
    }

    public int hashCode() {
        return new HashCodeBuilder().append(this.shard).append(this.country).hashCode();
    }

    public String toString() {
        return this.country + COUNTRY_SHARD_SEPARATOR + this.shard.getName();
    }
}

