/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.geography.matching;

import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.TreeSet;
import java.util.concurrent.TimeoutException;
import org.openstreetmap.atlas.geography.Location;
import org.openstreetmap.atlas.geography.PolyLine;
import org.openstreetmap.atlas.geography.Segment;
import org.openstreetmap.atlas.geography.matching.PolyLineRoute;
import org.openstreetmap.atlas.utilities.scalars.Distance;
import org.openstreetmap.atlas.utilities.scalars.Duration;
import org.openstreetmap.atlas.utilities.threads.Pool;
import org.openstreetmap.atlas.utilities.threads.Result;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PolyLineMatch {
    private static final Logger logger = LoggerFactory.getLogger(PolyLineMatch.class);
    private final PolyLine source;
    private final List<PolyLine> candidates;

    public PolyLineMatch(PolyLine source, List<PolyLine> candidates) {
        this.source = source;
        this.candidates = candidates;
    }

    public Optional<PolyLineRoute> match(Distance threshold) {
        if (this.candidates.isEmpty()) {
            return Optional.empty();
        }
        PolyLineRoute best = null;
        TreeSet candidateRoutes = new TreeSet();
        HashSet<Location> visitedStitchingLocations = new HashSet<Location>();
        int priorNumberOfCandidateRoutes = -1;
        boolean candidateRoutesEmpty = candidateRoutes.isEmpty();
        boolean bestNonNull = best != null;
        boolean bestCostTooHigh = false;
        boolean candidateRoutesIncreased = false;
        while (candidateRoutesEmpty || bestNonNull && bestCostTooHigh && candidateRoutesIncreased) {
            priorNumberOfCandidateRoutes = candidateRoutes.size();
            HashSet<PolyLineRoute> toAdd = new HashSet<PolyLineRoute>();
            for (int polyLineIndex = 0; polyLineIndex < this.candidates.size(); ++polyLineIndex) {
                PolyLine candidate = this.candidates.get(polyLineIndex);
                List<Segment> segments = candidate.segments();
                for (int segmentIndex = 0; segmentIndex < segments.size(); ++segmentIndex) {
                    if (candidateRoutes.isEmpty()) {
                        toAdd.add(PolyLineRoute.startFrom(this.source, this.candidates, polyLineIndex, segmentIndex));
                        continue;
                    }
                    for (PolyLineRoute existing : candidateRoutes) {
                        Optional<Location> stitchingLocation = existing.canAppend(polyLineIndex, segmentIndex);
                        if (!stitchingLocation.isPresent() || visitedStitchingLocations.contains(stitchingLocation.get())) continue;
                        visitedStitchingLocations.add(stitchingLocation.get());
                        PolyLineRoute elected = existing.copyAndAppend(polyLineIndex, segmentIndex);
                        if (candidateRoutes.contains(elected)) continue;
                        toAdd.add(elected);
                    }
                }
            }
            candidateRoutes.addAll(toAdd);
            best = (PolyLineRoute)candidateRoutes.first();
            candidateRoutesEmpty = candidateRoutes.isEmpty();
            bestNonNull = best != null;
            bestCostTooHigh = best.getCost().isGreaterThan(threshold);
            candidateRoutesIncreased = candidateRoutes.size() > priorNumberOfCandidateRoutes;
        }
        return Optional.ofNullable(best);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Optional<PolyLineRoute> match(Distance threshold, Duration maximum) {
        try (Pool polyLineMatchPool = new Pool(1, "PolyLine Match");){
            Result<Optional> result = polyLineMatchPool.queue(() -> this.match(threshold));
            Optional optional = result.get(maximum);
            return optional;
        }
        catch (TimeoutException e) {
            logger.warn("Was not able to compute PolyLineMatch in {} for {}", (Object)maximum, (Object)this.source);
            return Optional.empty();
        }
    }
}

