/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.geography.index;

import java.util.ArrayList;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.openstreetmap.atlas.exception.CoreException;
import org.openstreetmap.atlas.geography.Located;
import org.openstreetmap.atlas.geography.Rectangle;
import org.openstreetmap.atlas.geography.index.JtsSpatialIndex;
import org.openstreetmap.atlas.geography.index.SpatialIndex;

public abstract class PackedSpatialIndex<L extends Located, Packed>
implements SpatialIndex<L> {
    private static final long serialVersionUID = 1747435801359663115L;
    private final JtsSpatialIndex<Packed> index;

    public PackedSpatialIndex(JtsSpatialIndex<Packed> index) {
        this.index = index;
    }

    @Override
    public void add(L located) {
        Rectangle bounds = located.bounds();
        if (bounds == null) {
            throw new CoreException("Unable to get bounds for located item when building spatial index: {}", located);
        }
        this.index.add(bounds, this.compress(located));
    }

    @Override
    public Rectangle bounds() {
        return this.index.bounds();
    }

    @Override
    public Iterable<L> get(Rectangle bound) {
        return ((ArrayList)this.index.get(bound)).stream().map(this::restore).collect(Collectors.toList());
    }

    @Override
    public Iterable<L> get(Rectangle bound, Predicate<L> predicate) {
        return ((ArrayList)this.index.get(bound)).stream().map(this::restore).filter(predicate).collect(Collectors.toList());
    }

    protected abstract Packed compress(L var1);

    protected abstract boolean isValid(L var1, Rectangle var2);

    protected abstract L restore(Packed var1);
}

