/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.geography.converters.jts;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.CoordinateSequence;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.LinearRing;
import com.vividsolutions.jts.geom.Polygon;
import com.vividsolutions.jts.geom.impl.CoordinateArraySequence;
import java.util.List;
import org.openstreetmap.atlas.geography.converters.jts.JtsPrecisionManager;

public final class JtsUtility {
    public static final GeometryFactory GEOMETRY_FACTORY = JtsPrecisionManager.getGeometryFactory();
    private static final int MININMUM_NUMBER_OF_POLYGON_POINTS = 4;

    public static LinearRing buildLinearRing(CoordinateSequence sequence) {
        return new LinearRing(sequence, GEOMETRY_FACTORY);
    }

    public static LinearRing buildLinearRing(List<Coordinate> coordinates) {
        Coordinate[] coordinateArray = coordinates.toArray(new Coordinate[coordinates.size()]);
        CoordinateArraySequence sequence = new CoordinateArraySequence(coordinateArray);
        return new LinearRing(sequence, GEOMETRY_FACTORY);
    }

    public static LineString buildLineString(Coordinate[] coordinates) {
        CoordinateArraySequence sequence = new CoordinateArraySequence(coordinates);
        return new LineString(sequence, GEOMETRY_FACTORY);
    }

    public static Polygon toPolygon(Coordinate[] coordinates) {
        if (coordinates.length < 4 && coordinates.length != 0) {
            return null;
        }
        CoordinateArraySequence sequence = new CoordinateArraySequence(coordinates);
        LinearRing shell = new LinearRing(sequence, GEOMETRY_FACTORY);
        return new Polygon(shell, new LinearRing[0], GEOMETRY_FACTORY);
    }

    public static Polygon toPolygon(List<Coordinate> coordinates) {
        return JtsUtility.toPolygon(coordinates.toArray(new Coordinate[coordinates.size()]));
    }

    private JtsUtility() {
    }
}

