/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.geography.converters;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.io.ParseException;
import com.vividsolutions.jts.io.WKBReader;
import com.vividsolutions.jts.io.WKBWriter;
import java.util.ArrayList;
import java.util.List;
import org.openstreetmap.atlas.exception.CoreException;
import org.openstreetmap.atlas.geography.Latitude;
import org.openstreetmap.atlas.geography.Location;
import org.openstreetmap.atlas.geography.Longitude;
import org.openstreetmap.atlas.geography.PolyLine;
import org.openstreetmap.atlas.utilities.conversion.TwoWayConverter;

public class WkbPolyLineConverter
implements TwoWayConverter<PolyLine, byte[]> {
    @Override
    public PolyLine backwardConvert(byte[] wkb) {
        PolyLine polyLine = null;
        Geometry geometry = null;
        WKBReader myReader = new WKBReader();
        try {
            geometry = myReader.read(wkb);
        }
        catch (ParseException e) {
            throw new CoreException("Cannot parse wkb : {}", WKBWriter.toHex(wkb));
        }
        Coordinate[] coordinates = geometry.getCoordinates();
        ArrayList<Location> locations = new ArrayList<Location>();
        for (int i = 0; i < coordinates.length; ++i) {
            locations.add(new Location(Latitude.degrees(coordinates[i].y), Longitude.degrees(coordinates[i].x)));
        }
        polyLine = new PolyLine((List<? extends Location>)locations);
        return polyLine;
    }

    @Override
    public byte[] convert(PolyLine polyLine) {
        ArrayList<Coordinate> cooordinates = new ArrayList<Coordinate>();
        for (Location location : polyLine) {
            cooordinates.add(new Coordinate(location.getLongitude().asDegrees(), location.getLatitude().asDegrees()));
        }
        Coordinate[] coordinateArray = cooordinates.toArray(new Coordinate[cooordinates.size()]);
        Geometry geometry = coordinateArray.length == 1 ? new GeometryFactory().createPoint(coordinateArray[0]) : new GeometryFactory().createLineString(coordinateArray);
        byte[] wkb = new WKBWriter().write(geometry);
        return wkb;
    }
}

