/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.geography.converters;

import com.vividsolutions.jts.io.ParseException;
import com.vividsolutions.jts.io.WKBReader;
import com.vividsolutions.jts.io.WKBWriter;
import org.openstreetmap.atlas.exception.CoreException;
import org.openstreetmap.atlas.geography.MultiPolygon;
import org.openstreetmap.atlas.geography.converters.jts.JtsMultiPolygonToMultiPolygonConverter;
import org.openstreetmap.atlas.utilities.conversion.TwoWayConverter;

public class WkbMultiPolygonConverter
implements TwoWayConverter<MultiPolygon, byte[]> {
    private static final WKBReader WKB_READER = new WKBReader();

    @Override
    public MultiPolygon backwardConvert(byte[] wkb) {
        com.vividsolutions.jts.geom.MultiPolygon geometry = null;
        try {
            geometry = (com.vividsolutions.jts.geom.MultiPolygon)WKB_READER.read(wkb);
        }
        catch (ParseException | ClassCastException e) {
            throw new CoreException("Cannot parse wkb : {}", WKBWriter.toHex(wkb));
        }
        return new JtsMultiPolygonToMultiPolygonConverter().convert(geometry);
    }

    @Override
    public byte[] convert(MultiPolygon multiPolygon) {
        com.vividsolutions.jts.geom.MultiPolygon geometry = new JtsMultiPolygonToMultiPolygonConverter().backwardConvert(multiPolygon);
        byte[] wkb = new WKBWriter().write(geometry);
        return wkb;
    }
}

