/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.geography.converters;

import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.io.ParseException;
import com.vividsolutions.jts.io.WKBReader;
import com.vividsolutions.jts.io.WKBWriter;
import org.openstreetmap.atlas.exception.CoreException;
import org.openstreetmap.atlas.geography.Location;
import org.openstreetmap.atlas.geography.converters.jts.JtsPointConverter;
import org.openstreetmap.atlas.utilities.conversion.TwoWayConverter;

public class WkbLocationConverter
implements TwoWayConverter<Location, byte[]> {
    @Override
    public Location backwardConvert(byte[] wkb) {
        Point geometry = null;
        WKBReader myReader = new WKBReader();
        try {
            geometry = (Point)myReader.read(wkb);
        }
        catch (ParseException | ClassCastException e) {
            throw new CoreException("Cannot parse wkb : {}", WKBWriter.toHex(wkb));
        }
        return new JtsPointConverter().backwardConvert(geometry);
    }

    @Override
    public byte[] convert(Location location) {
        Point geometry = new JtsPointConverter().convert(location);
        byte[] wkb = new WKBWriter().write(geometry);
        return wkb;
    }
}

