/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.geography.converters;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import org.openstreetmap.atlas.exception.CoreException;
import org.openstreetmap.atlas.geography.Location;
import org.openstreetmap.atlas.geography.PolyLine;
import org.openstreetmap.atlas.geography.Polygon;
import org.openstreetmap.atlas.utilities.collections.Iterables;
import org.openstreetmap.atlas.utilities.collections.MultiIterable;
import org.openstreetmap.atlas.utilities.collections.StringList;
import org.openstreetmap.atlas.utilities.conversion.Converter;

public class MultiplePolyLineToPolygonsConverter
implements Converter<Iterable<PolyLine>, Iterable<Polygon>> {
    @Override
    public Iterable<Polygon> convert(Iterable<PolyLine> candidates) {
        ArrayList<PossiblePolygon> completes = new ArrayList<PossiblePolygon>();
        ArrayList<PossiblePolygon> incompletes = new ArrayList<PossiblePolygon>();
        LinkedList<PolyLine> remainingPolyLines = new LinkedList<PolyLine>();
        candidates.forEach(remainingPolyLines::add);
        int iterationsSinceLastPolyLineTaken = 0;
        while (!remainingPolyLines.isEmpty() && iterationsSinceLastPolyLineTaken <= remainingPolyLines.size()) {
            PolyLine candidate = (PolyLine)remainingPolyLines.removeFirst();
            boolean added = false;
            if (!incompletes.isEmpty()) {
                boolean completed = false;
                int index = -1;
                for (PossiblePolygon incomplete2 : incompletes) {
                    ++index;
                    if (!incomplete2.attach(candidate)) continue;
                    added = true;
                    completed = incomplete2.isCompleted();
                    break;
                }
                if (completed) {
                    PossiblePolygon increased = (PossiblePolygon)incompletes.get(index);
                    incompletes.remove(index);
                    completes.add(increased);
                }
            } else {
                PossiblePolygon incompleteCandidate = new PossiblePolygon(candidate);
                if (incompleteCandidate.isCompleted()) {
                    completes.add(incompleteCandidate);
                } else {
                    incompletes.add(incompleteCandidate);
                }
                added = true;
            }
            if (!added) {
                remainingPolyLines.addLast(candidate);
                ++iterationsSinceLastPolyLineTaken;
                continue;
            }
            iterationsSinceLastPolyLineTaken = 0;
        }
        if (!incompletes.isEmpty()) {
            throw new OpenPolygonException("Unable to close all the polygons!", Iterables.stream(incompletes).flatMap(incomplete -> Iterables.from(incomplete.firstLocation(), incomplete.lastLocation())).collectToList());
        }
        return completes.stream().map(PossiblePolygon::toPolygon).collect(Collectors.toList());
    }

    private static class PossiblePolygon {
        private boolean completed;
        private final List<PolyLine> polyLines = new ArrayList<PolyLine>();

        PossiblePolygon(PolyLine first) {
            this.completed = first instanceof Polygon || first.first().equals(first.last());
            this.polyLines.add(first);
        }

        public boolean attach(PolyLine candidate) {
            boolean result = false;
            ConnectResult canAppendCandidateToLine = this.canAppendSecondToFirst(this.lastPolyLine(), candidate);
            ConnectResult canPrependCandidateToLine = this.canPrependFirstToSecond(candidate, this.firstPolyLine());
            PolyLine toAdd = candidate;
            if (canAppendCandidateToLine.isConnected()) {
                if (canAppendCandidateToLine.isReversed()) {
                    toAdd = toAdd.reversed();
                }
                if (toAdd.size() > 1) {
                    toAdd = this.trimFirst(toAdd);
                } else {
                    if (canPrependCandidateToLine.isConnected()) {
                        this.completed = true;
                    }
                    return true;
                }
            }
            if (canPrependCandidateToLine.isConnected()) {
                if (canPrependCandidateToLine.isReversed() && !canAppendCandidateToLine.isConnected()) {
                    toAdd = toAdd.reversed();
                }
                if (toAdd.size() > 1) {
                    toAdd = this.trimLast(toAdd);
                } else {
                    if (canAppendCandidateToLine.isConnected()) {
                        this.completed = true;
                    }
                    return true;
                }
            }
            if (canAppendCandidateToLine.isConnected()) {
                this.polyLines.add(toAdd);
                result = true;
            } else if (canPrependCandidateToLine.isConnected()) {
                this.polyLines.add(0, toAdd);
                result = true;
            }
            if (canPrependCandidateToLine.isConnected() && canAppendCandidateToLine.isConnected()) {
                this.completed = true;
            }
            return result;
        }

        public Location firstLocation() {
            return this.polyLines.get(0).first();
        }

        public boolean isCompleted() {
            return this.completed;
        }

        public Location lastLocation() {
            return this.polyLines.get(this.polyLines.size() - 1).last();
        }

        public int size() {
            return this.polyLines.size();
        }

        public Polygon toPolygon() {
            if (!this.isCompleted() && this.size() >= 1) {
                ArrayList<Location> openLocations = new ArrayList<Location>();
                Location firstLocation = this.polyLines.get(0).first();
                Location lastLocation = this.polyLines.get(this.size() - 1).last();
                if (firstLocation != null && lastLocation != null) {
                    openLocations.add(firstLocation);
                    openLocations.add(lastLocation);
                    throw new OpenPolygonException("Cannot build polygon with multiple polylines. Loop is not closed.", openLocations);
                }
            }
            return new Polygon((Iterable<Location>)new MultiIterable<Location>((Iterable<Iterable<Location>>)this.polyLines));
        }

        public String toString() {
            StringList list = new StringList();
            this.polyLines.forEach(polyLine -> list.add(polyLine.first() + " -> "));
            list.add(this.lastLocation());
            return list.join("");
        }

        private ConnectResult canAppendSecondToFirst(PolyLine one, PolyLine two) {
            if (one.last().equals(two.first())) {
                return new ConnectResult(true, false);
            }
            if (one.last().equals(two.last())) {
                return new ConnectResult(true, true);
            }
            return new ConnectResult(false, false);
        }

        private ConnectResult canPrependFirstToSecond(PolyLine one, PolyLine two) {
            if (one.last().equals(two.first())) {
                return new ConnectResult(true, false);
            }
            if (one.first().equals(two.first())) {
                return new ConnectResult(true, true);
            }
            return new ConnectResult(false, false);
        }

        private PolyLine firstPolyLine() {
            return this.polyLines.get(0);
        }

        private PolyLine lastPolyLine() {
            return this.polyLines.get(this.polyLines.size() - 1);
        }

        private PolyLine trimFirst(PolyLine current) {
            ArrayList<Location> result = new ArrayList<Location>();
            for (Location location : current) {
                result.add(location);
            }
            result.remove(0);
            return new PolyLine((List<? extends Location>)result);
        }

        private PolyLine trimLast(PolyLine current) {
            ArrayList<Location> result = new ArrayList<Location>();
            for (Location location : current) {
                result.add(location);
            }
            result.remove(result.size() - 1);
            return new PolyLine((List<? extends Location>)result);
        }
    }

    private static class ConnectResult {
        private final boolean connected;
        private final boolean reversed;

        ConnectResult(boolean connected, boolean reversed) {
            this.connected = connected;
            this.reversed = reversed;
        }

        public boolean isConnected() {
            return this.connected;
        }

        public boolean isReversed() {
            return this.reversed;
        }

        public String toString() {
            return this.connected ? "Connected" + (this.reversed ? " and reversed" : "") : "Not connected";
        }
    }

    public static class OpenPolygonException
    extends CoreException {
        private static final long serialVersionUID = -278028096455310936L;
        private final List<Location> openLocations;

        public OpenPolygonException(String message, List<Location> openLocations) {
            super(message + " Open Locations are: " + openLocations.toString());
            this.openLocations = openLocations;
        }

        public OpenPolygonException(String message, List<Location> openLocations, Object ... arguments) {
            super(message + " Open Locations are: " + openLocations.toString(), arguments);
            this.openLocations = openLocations;
        }

        public OpenPolygonException(String message, List<Location> openLocations, Throwable cause, Object ... arguments) {
            super(message + " Open Locations are: " + openLocations.toString(), cause, arguments);
            this.openLocations = openLocations;
        }

        public List<Location> getOpenLocations() {
            return this.openLocations;
        }
    }
}

