/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.geography.converters;

import org.openstreetmap.atlas.geography.Altitude;
import org.openstreetmap.atlas.geography.Latitude;
import org.openstreetmap.atlas.geography.Longitude;
import org.openstreetmap.atlas.geography.constants.WorldGeodeticStandardConstants;
import org.openstreetmap.atlas.geography.coordinates.EarthCenteredEarthFixedCoordinate;
import org.openstreetmap.atlas.geography.coordinates.GeodeticCoordinate;
import org.openstreetmap.atlas.utilities.conversion.TwoWayConverter;

public class GeodeticEarthCenteredEarthFixedConverter
implements TwoWayConverter<GeodeticCoordinate, EarthCenteredEarthFixedCoordinate> {
    @Override
    public GeodeticCoordinate backwardConvert(EarthCenteredEarthFixedCoordinate coordinate) {
        double semiMinor = Math.sqrt(WorldGeodeticStandardConstants.SEMI_MAJOR_AXIS_SQUARED * (1.0 - WorldGeodeticStandardConstants.ECCENTRICITY_SQUARED));
        double semiMinorSquared = Math.pow(semiMinor, 2.0);
        double secondEccentricity = Math.sqrt((WorldGeodeticStandardConstants.SEMI_MAJOR_AXIS_SQUARED - semiMinorSquared) / semiMinorSquared);
        double auxiliaryP = Math.sqrt(Math.pow(coordinate.getX(), 2.0) + Math.pow(coordinate.getY(), 2.0));
        double theta = Math.atan2(coordinate.getZ() * WorldGeodeticStandardConstants.SEMI_MAJOR_AXIS.asMeters(), auxiliaryP * semiMinor);
        double longitude = Math.atan2(coordinate.getY(), coordinate.getX());
        double latitude = Math.atan2(coordinate.getZ() + Math.pow(secondEccentricity, 2.0) * semiMinor * Math.pow(Math.sin(theta), 3.0), auxiliaryP - WorldGeodeticStandardConstants.ECCENTRICITY_SQUARED * WorldGeodeticStandardConstants.SEMI_MAJOR_AXIS.asMeters() * Math.pow(Math.cos(theta), 3.0));
        double radiusOfCurviture = WorldGeodeticStandardConstants.SEMI_MAJOR_AXIS.asMeters() / Math.sqrt(1.0 - WorldGeodeticStandardConstants.ECCENTRICITY_SQUARED * Math.pow(Math.sin(latitude), 2.0));
        double altitude = auxiliaryP / Math.cos(latitude) - radiusOfCurviture;
        return new GeodeticCoordinate(Latitude.radians(latitude), Longitude.radians(longitude), Altitude.meters(altitude));
    }

    @Override
    public EarthCenteredEarthFixedCoordinate convert(GeodeticCoordinate coordinate) {
        double radiusOfCurviture = WorldGeodeticStandardConstants.SEMI_MAJOR_AXIS.asMeters() / Math.sqrt(1.0 - WorldGeodeticStandardConstants.ECCENTRICITY_SQUARED * Math.pow(Math.sin(coordinate.getLatitude().asPositiveRadians()), 2.0));
        double height = coordinate.getAltitude().asMeters();
        double xValue = (radiusOfCurviture + height) * Math.cos(coordinate.getLatitude().asPositiveRadians()) * Math.cos(coordinate.getLongitude().asPositiveRadians());
        double yValue = (radiusOfCurviture + height) * Math.cos(coordinate.getLatitude().asPositiveRadians()) * Math.sin(coordinate.getLongitude().asPositiveRadians());
        double zValue = ((1.0 - WorldGeodeticStandardConstants.ECCENTRICITY_SQUARED) * radiusOfCurviture + height) * Math.sin(coordinate.getLatitude().asPositiveRadians());
        return new EarthCenteredEarthFixedCoordinate(xValue, yValue, zValue);
    }
}

