/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.geography.clipping;

import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryCollection;
import com.vividsolutions.jts.geom.LineString;
import java.util.ArrayList;
import java.util.List;
import org.openstreetmap.atlas.geography.PolyLine;
import org.openstreetmap.atlas.geography.Polygon;
import org.openstreetmap.atlas.geography.converters.jts.JtsPolyLineConverter;
import org.openstreetmap.atlas.geography.converters.jts.JtsPolygonConverter;

public class PolygonClipper {
    private final Geometry jtsClipping;

    public static Geometry getJts(PolyLine polyLine) {
        if (polyLine instanceof Polygon) {
            return new JtsPolygonConverter().convert((Polygon)polyLine);
        }
        return new JtsPolyLineConverter().convert(polyLine);
    }

    public PolygonClipper(Polygon clipping) {
        this.jtsClipping = PolygonClipper.getJts(clipping);
    }

    public List<? extends PolyLine> and(PolyLine subject) {
        return this.processResult(PolygonClipper.getJts(subject).intersection(this.jtsClipping));
    }

    public List<? extends PolyLine> not(PolyLine subject) {
        return this.processResult(PolygonClipper.getJts(subject).difference(this.jtsClipping));
    }

    public List<? extends PolyLine> union(PolyLine subject) {
        return this.processResult(PolygonClipper.getJts(subject).union(this.jtsClipping));
    }

    public List<? extends PolyLine> xor(PolyLine subject) {
        return this.processResult(PolygonClipper.getJts(subject).symDifference(this.jtsClipping));
    }

    private List<? extends PolyLine> processResult(Geometry intersections) {
        ArrayList<? extends PolyLine> result = new ArrayList<PolyLine>();
        if (intersections instanceof GeometryCollection) {
            GeometryCollection collection = (GeometryCollection)intersections;
            int numGeometries = collection.getNumGeometries();
            for (int n = 0; n < numGeometries; ++n) {
                Geometry geometry = collection.getGeometryN(n);
                result.addAll(this.processResult(geometry));
            }
        } else if (intersections instanceof com.vividsolutions.jts.geom.Polygon) {
            result.add(new JtsPolygonConverter().backwardConvert((com.vividsolutions.jts.geom.Polygon)intersections));
        } else if (intersections instanceof LineString) {
            result.add(new JtsPolyLineConverter().backwardConvert((LineString)intersections));
        }
        return result;
    }
}

