/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.geography.boundary;

import java.util.concurrent.BlockingQueue;
import org.openstreetmap.atlas.geography.Rectangle;
import org.openstreetmap.atlas.geography.boundary.CountryBoundary;
import org.openstreetmap.atlas.geography.boundary.CountryBoundaryMap;
import org.openstreetmap.atlas.geography.sharding.Shard;
import org.openstreetmap.atlas.geography.sharding.Sharding;
import org.openstreetmap.atlas.utilities.maps.MultiMapWithSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CountryShardListingProcessor
implements Runnable {
    private static final Logger logger = LoggerFactory.getLogger(CountryShardListingProcessor.class);
    private final BlockingQueue<CountryBoundary> queue;
    private final Sharding sharding;
    private final CountryBoundaryMap boundaryMap;
    private final MultiMapWithSet<String, Shard> countryToShardMap;

    CountryShardListingProcessor(BlockingQueue<CountryBoundary> queue, Sharding sharding, CountryBoundaryMap boundaryMap, MultiMapWithSet<String, Shard> countryToShardMap) {
        this.queue = queue;
        this.sharding = sharding;
        this.boundaryMap = boundaryMap;
        this.countryToShardMap = countryToShardMap;
    }

    @Override
    public void run() {
        try {
            while (!this.queue.isEmpty()) {
                CountryBoundary itemToProcess = (CountryBoundary)this.queue.poll();
                if (itemToProcess == null) continue;
                this.process(itemToProcess);
            }
        }
        catch (Exception e) {
            logger.error("Processor failed to process.", (Throwable)e);
        }
    }

    private void process(CountryBoundary item) {
        this.sharding.shards(item.getBoundary().bounds()).forEach(shard -> {
            String country = item.getCountryName();
            Rectangle shardBounds = shard.bounds();
            if (this.boundaryMap.countryCodesOverlappingWith(shardBounds).contains(country) && item.getBoundary().overlaps(shardBounds)) {
                Object shards;
                Object object = shards = this.countryToShardMap.get(country);
                synchronized (object) {
                    shards.add(shard);
                }
            }
        });
    }
}

