/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.geography.boundary;

import java.io.IOException;
import org.openstreetmap.atlas.exception.CoreException;
import org.openstreetmap.atlas.geography.Rectangle;
import org.openstreetmap.atlas.geography.atlas.Atlas;
import org.openstreetmap.atlas.geography.atlas.packed.PackedAtlas;
import org.openstreetmap.atlas.geography.boundary.CountryBoundaryMap;
import org.openstreetmap.atlas.streaming.compression.Compressor;
import org.openstreetmap.atlas.streaming.resource.File;
import org.openstreetmap.atlas.streaming.resource.Resource;
import org.openstreetmap.atlas.utilities.collections.StringList;
import org.openstreetmap.atlas.utilities.runtime.Command;
import org.openstreetmap.atlas.utilities.runtime.CommandMap;
import org.openstreetmap.atlas.utilities.time.Time;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CountryBoundaryMapArchiver
extends Command {
    private static final Logger logger = LoggerFactory.getLogger(CountryBoundaryMapArchiver.class);
    private static final Command.Switch<File> SHAPE_FILE = new Command.Switch("shp", "path to the shape file", File::new, Command.Optionality.OPTIONAL);
    private static final Command.Switch<Atlas> ATLAS = new Command.Switch("atlas", "path to the atlas file containing boundaries", path -> PackedAtlas.load(new File((String)path)), Command.Optionality.OPTIONAL);
    private static final Command.Switch<File> OUTPUT = new Command.Switch("out", "The output file format", path -> new File((String)path));
    public static final Command.Switch<StringList> COUNTRIES = new Command.Switch("countries", "Comma separated list of countries to be included in the boundary file", value -> StringList.split(value, ","), Command.Optionality.OPTIONAL);
    private static final Command.Switch<Rectangle> BOUNDS = new Command.Switch("bounds", "The bounds", rectangle -> Rectangle.forString(rectangle), Command.Optionality.OPTIONAL, Rectangle.MAXIMUM.toCompactString());
    private static final Command.Switch<Boolean> CREATE_SPATIAL_INDEX = new Command.Switch("createSpatialIndex", "Indicator whether to create a spatial grid index and include that in the output.", Boolean::parseBoolean, Command.Optionality.OPTIONAL, Boolean.FALSE.toString());

    public static void main(String[] args) {
        new CountryBoundaryMapArchiver().run(args);
    }

    public CountryBoundaryMap read(Resource resource) {
        return CountryBoundaryMap.fromPlainText(resource);
    }

    @Override
    protected int onRun(CommandMap command) {
        File shapeFile = (File)command.get(SHAPE_FILE);
        Atlas atlas = (Atlas)command.get(ATLAS);
        File output = (File)command.get(OUTPUT);
        output.setCompressor(Compressor.GZIP);
        Rectangle bounds = (Rectangle)command.get(BOUNDS);
        boolean createIndex = (Boolean)command.get(CREATE_SPATIAL_INDEX);
        Time timer = Time.now();
        CountryBoundaryMap map = new CountryBoundaryMap(bounds);
        if (atlas != null) {
            map.readFromAtlas(atlas);
        }
        if (shapeFile != null) {
            map.readFromShapeFile(shapeFile.getFile());
        }
        if (createIndex) {
            logger.info("Building Grid Index...");
            Time startTime = Time.now();
            map.initializeGridIndex(map.getLoadedCountries());
            logger.info("Finished building Grid Index in {}", (Object)startTime.elapsedSince());
        }
        try {
            logger.info("Saving CountryBoundaryMap to {}.", (Object)output);
            map.writeToFile(output);
            map.boundaries(Rectangle.MAXIMUM).forEach(boundary -> logger.info("Loaded boundary for country {}", (Object)boundary.getCountryName()));
        }
        catch (IOException e) {
            throw new CoreException("Could not write CountryBoundaryMap.");
        }
        logger.info("CountryBoundaryMap creation took {}.", (Object)timer.elapsedSince());
        return 0;
    }

    @Override
    protected Command.SwitchList switches() {
        return new Command.SwitchList().with(SHAPE_FILE, ATLAS, OUTPUT, BOUNDS, CREATE_SPATIAL_INDEX);
    }
}

