/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.geography.boundary;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.LinearRing;
import com.vividsolutions.jts.geom.Polygon;
import com.vividsolutions.jts.geom.impl.CoordinateArraySequence;
import com.vividsolutions.jts.index.strtree.STRtree;
import java.util.List;
import org.openstreetmap.atlas.geography.converters.jts.JtsUtility;

public abstract class AbstractGridIndexBuilder {
    public static Polygon buildGeoBox(double minX, double maxX, double minY, double maxY) {
        Coordinate lowerLeft = new Coordinate(minX, maxY);
        Coordinate lowerRight = new Coordinate(maxX, maxY);
        Coordinate upperRight = new Coordinate(maxX, minY);
        Coordinate upperLeft = new Coordinate(minX, minY);
        LinearRing shell = new LinearRing(new CoordinateArraySequence(new Coordinate[]{lowerLeft, lowerRight, upperRight, upperLeft, lowerLeft}), JtsUtility.GEOMETRY_FACTORY);
        Polygon geoBox = new Polygon(shell, null, JtsUtility.GEOMETRY_FACTORY);
        return geoBox;
    }

    public abstract List<Polygon> getBoundaries();

    public abstract Envelope getEnvelope();

    public abstract STRtree getIndex();
}

