/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.geography.atlas.raw.slicing.changeset;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.openstreetmap.atlas.exception.CoreException;
import org.openstreetmap.atlas.geography.atlas.Atlas;
import org.openstreetmap.atlas.geography.atlas.builder.RelationBean;
import org.openstreetmap.atlas.geography.atlas.items.ItemType;
import org.openstreetmap.atlas.geography.atlas.items.Line;
import org.openstreetmap.atlas.geography.atlas.items.Point;
import org.openstreetmap.atlas.geography.atlas.items.Relation;
import org.openstreetmap.atlas.geography.atlas.items.RelationMember;
import org.openstreetmap.atlas.geography.atlas.raw.slicing.changeset.ChangeSetHandler;
import org.openstreetmap.atlas.geography.atlas.raw.slicing.changeset.SimpleChangeSet;
import org.openstreetmap.atlas.geography.atlas.raw.temporary.TemporaryLine;
import org.openstreetmap.atlas.utilities.time.Time;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleChangeSetHandler
extends ChangeSetHandler {
    private static final Logger logger = LoggerFactory.getLogger(SimpleChangeSetHandler.class);
    private final SimpleChangeSet changeSet;
    private final Set<Long> filteredEmptyRelations = new HashSet<Long>();

    public SimpleChangeSetHandler(Atlas atlas, SimpleChangeSet changeSet) {
        super(atlas);
        this.changeSet = changeSet;
    }

    @Override
    public Atlas applyChanges() {
        Time time = Time.now();
        logger.info("Started Applying Point and Line Changes for {}", (Object)this.getShardOrAtlasName());
        logger.info(this.atlasStatistics(this.getAtlas()));
        this.setAtlasSizeEstimateAndMetadata();
        this.addNewPoints();
        this.addUpdatedPoints();
        this.addNewLines();
        this.addUpdatedLines();
        this.updateAndAddRelations();
        Atlas atlasWithUpdates = this.getBuilder().get();
        logger.info(this.atlasStatistics(atlasWithUpdates));
        logger.info("Finished Applying Point and Line Changes for {} in {}", (Object)this.getShardOrAtlasName(), (Object)time.elapsedSince());
        return atlasWithUpdates;
    }

    private void addNewLines() {
        this.changeSet.getCreatedLines().forEach(line -> this.getBuilder().addLine(line.getIdentifier(), this.reconstructGeometryForLine((TemporaryLine)line), line.getTags()));
    }

    private void addNewPoints() {
        this.changeSet.getCreatedPoints().forEach(point -> this.getBuilder().addPoint(point.getIdentifier(), point.getLocation(), point.getTags()));
    }

    private void addUpdatedLines() {
        this.getAtlas().lines().forEach(line -> {
            long lineIdentifier = line.getIdentifier();
            if (!this.changeSet.getDeletedToCreatedLineMapping().keySet().contains(lineIdentifier)) {
                if (this.changeSet.getUpdatedLineTags().containsKey(lineIdentifier)) {
                    Line originalLine = this.getAtlas().line(lineIdentifier);
                    Map<String, String> updatedTags = originalLine.getTags();
                    updatedTags.putAll(this.changeSet.getUpdatedLineTags().get(lineIdentifier));
                    this.getBuilder().addLine(lineIdentifier, originalLine.asPolyLine(), updatedTags);
                } else {
                    logger.error("Adding Line {} with missing country code to maintain Atlas integrity.", (Object)lineIdentifier);
                    Map<String, String> updatedTags = line.getTags();
                    updatedTags.put("iso_country_code", "N/A");
                    this.getBuilder().addLine(lineIdentifier, line.asPolyLine(), updatedTags);
                }
            }
        });
    }

    private void addUpdatedPoints() {
        this.getAtlas().points().forEach(point -> {
            long pointIdentifier = point.getIdentifier();
            if (this.changeSet.getUpdatedPointTags().containsKey(pointIdentifier)) {
                Point originalPoint = this.getAtlas().point(pointIdentifier);
                Map<String, String> updatedTags = originalPoint.getTags();
                updatedTags.putAll(this.changeSet.getUpdatedPointTags().get(pointIdentifier));
                this.getBuilder().addPoint(pointIdentifier, originalPoint.getLocation(), updatedTags);
            }
        });
    }

    private void updateAndAddRelations() {
        for (Relation relation : this.getAtlas().relationsLowerOrderFirst()) {
            RelationBean bean = new RelationBean();
            for (RelationMember member : relation.members()) {
                long memberIdentifier = member.getEntity().getIdentifier();
                ItemType memberType = member.getEntity().getType();
                if (memberType == ItemType.LINE && this.changeSet.getDeletedToCreatedLineMapping().keySet().contains(memberIdentifier)) {
                    for (long addedLineIdentifier : this.changeSet.getDeletedToCreatedLineMapping().get(memberIdentifier)) {
                        if (this.getBuilder().peek().line(addedLineIdentifier) != null) {
                            bean.addItem(addedLineIdentifier, member.getRole(), member.getEntity().getType());
                            continue;
                        }
                        throw new CoreException("Corrupt Data! Trying to replace deleted Line member {} with created Line member {} for Relation {} , but new Line doesn't exist in Atlas.", memberIdentifier, addedLineIdentifier, relation.getIdentifier());
                    }
                    continue;
                }
                if (memberType == ItemType.POINT && this.changeSet.getDeletedPoints().contains(memberIdentifier)) {
                    logger.trace("Point {} wasn't in the working country set and is being filtered out of Relation {}", (Object)memberIdentifier, (Object)relation.getIdentifier());
                    continue;
                }
                if (memberType == ItemType.RELATION && this.filteredEmptyRelations.contains(memberIdentifier)) {
                    logger.trace("Relation {} is empty as a result of slicing and is being filtered out of parent Relation {}", (Object)memberIdentifier, (Object)relation.getIdentifier());
                    continue;
                }
                bean.addItem(member.getEntity().getIdentifier(), member.getRole(), member.getEntity().getType());
            }
            if (!bean.isEmpty()) {
                this.getBuilder().addRelation(relation.getIdentifier(), relation.getOsmIdentifier(), bean, relation.getTags());
                continue;
            }
            this.filteredEmptyRelations.add(relation.getIdentifier());
            logger.trace("Excluding Relation {} from Atlas due to empty member list", (Object)relation.getIdentifier());
        }
    }
}

