/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.geography.atlas.raw.slicing;

import com.google.common.base.Joiner;
import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.TopologyException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.openstreetmap.atlas.exception.CoreException;
import org.openstreetmap.atlas.geography.Location;
import org.openstreetmap.atlas.geography.Polygon;
import org.openstreetmap.atlas.geography.atlas.Atlas;
import org.openstreetmap.atlas.geography.atlas.items.Line;
import org.openstreetmap.atlas.geography.atlas.items.Point;
import org.openstreetmap.atlas.geography.atlas.pbf.slicing.identifier.CountrySlicingIdentifierFactory;
import org.openstreetmap.atlas.geography.atlas.raw.slicing.CoordinateToNewPointMapping;
import org.openstreetmap.atlas.geography.atlas.raw.slicing.RawAtlasSlicer;
import org.openstreetmap.atlas.geography.atlas.raw.slicing.changeset.ChangeSetHandler;
import org.openstreetmap.atlas.geography.atlas.raw.slicing.changeset.SimpleChangeSet;
import org.openstreetmap.atlas.geography.atlas.raw.slicing.changeset.SimpleChangeSetHandler;
import org.openstreetmap.atlas.geography.atlas.raw.temporary.TemporaryEntity;
import org.openstreetmap.atlas.geography.atlas.raw.temporary.TemporaryLine;
import org.openstreetmap.atlas.geography.atlas.raw.temporary.TemporaryPoint;
import org.openstreetmap.atlas.geography.boundary.CountryBoundaryMap;
import org.openstreetmap.atlas.tags.Taggable;
import org.openstreetmap.atlas.utilities.collections.Iterables;
import org.openstreetmap.atlas.utilities.time.Time;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RawAtlasPointAndLineSlicer
extends RawAtlasSlicer {
    private static final Logger logger = LoggerFactory.getLogger(RawAtlasPointAndLineSlicer.class);
    private final Atlas rawAtlas;
    private final SimpleChangeSet slicedPointAndLineChanges;
    private final Set<Long> pointsMarkedForRemoval = new HashSet<Long>();

    public RawAtlasPointAndLineSlicer(Set<String> countries, CountryBoundaryMap countryBoundaryMap, Atlas atlas, SimpleChangeSet changeSet, CoordinateToNewPointMapping newPointCoordinates) {
        super(countries, countryBoundaryMap, newPointCoordinates);
        this.rawAtlas = atlas;
        this.slicedPointAndLineChanges = changeSet;
    }

    @Override
    public Atlas slice() {
        Time time = Time.now();
        logger.info("Starting Point and Line Slicing for {}", (Object)this.getShardOrAtlasName());
        this.sliceLines();
        this.slicePoints();
        SimpleChangeSetHandler simpleChangeBuilder = new SimpleChangeSetHandler(this.rawAtlas, this.slicedPointAndLineChanges);
        Atlas atlasWithSlicedWaysAndPoints = ((ChangeSetHandler)simpleChangeBuilder).applyChanges();
        logger.info("Finished Point and Line Slicing for {} in {}", (Object)this.getShardOrAtlasName(), (Object)time.elapsedSince());
        this.getStatistics().summary();
        return atlasWithSlicedWaysAndPoints;
    }

    private List<Geometry> convertToJtsGeometryAndSlice(Line line) {
        long lineIdentifier = line.getIdentifier();
        Geometry geometry = line.isClosed() ? JTS_POLYGON_CONVERTER.convert(new Polygon(line)) : JTS_POLYLINE_CONVERTER.convert(line.asPolyLine());
        List<Geometry> result = this.sliceGeometry(geometry, lineIdentifier);
        if ((result == null || result.isEmpty()) && line.isClosed()) {
            geometry = JTS_POLYLINE_CONVERTER.convert(line.asPolyLine());
            result = this.sliceGeometry(geometry, lineIdentifier);
        }
        if (result == null || result.isEmpty()) {
            logger.error("Invalid Geometry for line {}", (Object)lineIdentifier);
        }
        return result;
    }

    private String getShardOrAtlasName() {
        return this.rawAtlas.metaData().getShardName().orElse(this.rawAtlas.getName());
    }

    private boolean isOutsideWorkingBound(Geometry geometry) {
        String countryCode = CountryBoundaryMap.getGeometryProperty(geometry, "iso_country_code");
        if (countryCode != null) {
            return this.getCountries() != null && !this.getCountries().isEmpty() && !this.getCountries().contains(countryCode);
        }
        return false;
    }

    private boolean isOutsideWorkingBound(Map<String, String> tags) {
        if (this.getCountries() != null && !this.getCountries().isEmpty()) {
            String[] countryCodes;
            String tagValue = tags.get("iso_country_code");
            for (String countryCode : countryCodes = tagValue.split(",")) {
                if (!this.getCountries().contains(countryCode)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    private void processLineSlices(Line line, List<Geometry> slices) {
        if (slices == null || slices.isEmpty()) {
            HashMap<String, String> tags = new HashMap<String, String>();
            tags.put("iso_country_code", "N/A");
            this.slicedPointAndLineChanges.updateLineTags(line.getIdentifier(), tags);
            this.updateLineShapePoints(line);
        } else if (this.slicesBelongToSingleCountry(slices) && !this.getCountryBoundaryMap().shouldForceSlicing(line)) {
            if (this.isOutsideWorkingBound(slices.get(0))) {
                this.slicedPointAndLineChanges.createDeletedToCreatedMapping(line.getIdentifier(), Collections.emptySet());
            } else {
                this.slicedPointAndLineChanges.updateLineTags(line.getIdentifier(), RawAtlasPointAndLineSlicer.createLineTags(slices.get(0), line.getTags()));
                this.updateLineShapePoints(line);
            }
        } else if ((long)slices.size() < 1000L) {
            CountrySlicingIdentifierFactory lineIdentifierFactory = new CountrySlicingIdentifierFactory(line.getIdentifier());
            CountrySlicingIdentifierFactory pointIdentifierFactory = new CountrySlicingIdentifierFactory(line.getIdentifier());
            ArrayList<TemporaryLine> createdLines = new ArrayList<TemporaryLine>();
            try {
                for (Geometry slice : slices) {
                    Coordinate[] jtsSliceCoordinates;
                    if (this.isOutsideWorkingBound(slice)) {
                        this.removeShapePointsFromFilteredSliced(slice);
                        continue;
                    }
                    ArrayList<Long> newLineShapePoints = new ArrayList<Long>(slice.getNumPoints());
                    for (Coordinate coordinate : jtsSliceCoordinates = slice.getCoordinates()) {
                        Map<String, String> pointTags;
                        RawAtlasPointAndLineSlicer.roundCoordinate(coordinate);
                        if (this.getCoordinateToPointMapping().containsCoordinate(coordinate)) {
                            newLineShapePoints.add(this.getCoordinateToPointMapping().getPointForCoordinate(coordinate));
                            continue;
                        }
                        Location coordinateLocation = JTS_LOCATION_CONVERTER.backwardConvert(coordinate);
                        Iterable<Point> rawAtlasPointsAtSliceVertex = this.rawAtlas.pointsAt(coordinateLocation);
                        if (Iterables.isEmpty(rawAtlasPointsAtSliceVertex)) {
                            pointTags = this.createPointTags(coordinateLocation, false);
                            TemporaryPoint newPoint = RawAtlasPointAndLineSlicer.createNewPoint(coordinate, pointIdentifierFactory, pointTags);
                            this.getCoordinateToPointMapping().storeMapping(coordinate, newPoint.getIdentifier());
                            newLineShapePoints.add(newPoint.getIdentifier());
                            this.slicedPointAndLineChanges.createPoint(newPoint);
                            continue;
                        }
                        pointTags = this.createPointTags(coordinateLocation, true);
                        for (Point rawAtlasPoint : rawAtlasPointsAtSliceVertex) {
                            this.pointsMarkedForRemoval.remove(rawAtlasPoint.getIdentifier());
                            this.slicedPointAndLineChanges.updatePointTags(rawAtlasPoint.getIdentifier(), pointTags);
                            newLineShapePoints.add(rawAtlasPoint.getIdentifier());
                        }
                    }
                    Map<String, String> lineTags = RawAtlasPointAndLineSlicer.createLineTags(slice, line.getTags());
                    TemporaryLine createdLine2 = new TemporaryLine(lineIdentifierFactory.nextIdentifier(), newLineShapePoints, lineTags);
                    createdLines.add(createdLine2);
                }
                createdLines.forEach(createdLine -> this.slicedPointAndLineChanges.createLine((TemporaryLine)createdLine));
                this.slicedPointAndLineChanges.createDeletedToCreatedMapping(line.getIdentifier(), createdLines.stream().map(TemporaryEntity::getIdentifier).collect(Collectors.toSet()));
                this.getStatistics().recordSlicedLine();
            }
            catch (CoreException e) {
                logger.error("Country slicing exceeded maximum point identifier name space of {} for Line {}. It will be added as is, with two or more country codes.", new Object[]{1000L, line.getIdentifier(), e});
                this.updateLineToHaveCountryCodesFromAllSlices(line, slices);
                this.getStatistics().recordSkippedLine();
            }
        } else {
            logger.error("Country slicing exceeded maximum line identifier name space of {} for Line {}. It will be added as is, with two or more country codes.", (Object)1000L, (Object)line.getIdentifier());
            this.updateLineToHaveCountryCodesFromAllSlices(line, slices);
            this.getStatistics().recordSkippedLine();
        }
    }

    private void removeShapePointsFromFilteredSliced(Geometry slice) {
        Coordinate[] jtsSliceCoordinates;
        for (Coordinate coordinate : jtsSliceCoordinates = slice.getCoordinates()) {
            Location location = JTS_LOCATION_CONVERTER.backwardConvert(coordinate);
            Iterable<Point> existingRawAtlasPoints = this.rawAtlas.pointsAt(location);
            existingRawAtlasPoints.forEach(point -> this.pointsMarkedForRemoval.add(point.getIdentifier()));
        }
    }

    private List<Geometry> sliceGeometry(Geometry geometry, long identifier) {
        try {
            return this.getCountryBoundaryMap().slice(identifier, geometry, new Taggable[0]);
        }
        catch (TopologyException e) {
            logger.error("Topology Exception when slicing Line {}", (Object)identifier, (Object)e);
            return Collections.emptyList();
        }
    }

    private void sliceLine(Line line) {
        this.getStatistics().recordProcessedLine();
        List<Geometry> slices = this.convertToJtsGeometryAndSlice(line);
        this.processLineSlices(line, slices);
    }

    private void sliceLines() {
        StreamSupport.stream(this.rawAtlas.lines().spliterator(), true).forEach(this::sliceLine);
    }

    private void slicePoints() {
        StreamSupport.stream(this.rawAtlas.points().spliterator(), true).forEach(point -> {
            long pointIdentifier = point.getIdentifier();
            if (!this.slicedPointAndLineChanges.getUpdatedPointTags().containsKey(pointIdentifier) && !this.pointsMarkedForRemoval.contains(pointIdentifier)) {
                this.getStatistics().recordProcessedPoint();
                Map<String, String> updatedTags = this.createPointTags(point.getLocation(), true);
                if (this.isOutsideWorkingBound(updatedTags)) {
                    this.slicedPointAndLineChanges.deletePoint(pointIdentifier);
                } else {
                    this.slicedPointAndLineChanges.updatePointTags(pointIdentifier, updatedTags);
                }
            }
        });
        this.pointsMarkedForRemoval.forEach(this.slicedPointAndLineChanges::deletePoint);
    }

    private boolean slicesBelongToSingleCountry(List<Geometry> slices) {
        return slices.size() == 1 || CountryBoundaryMap.isSameCountry(slices);
    }

    private void updateLineShapePoints(Line line) {
        for (Location location : line.asPolyLine()) {
            for (Point point : this.rawAtlas.pointsAt(location)) {
                this.getStatistics().recordProcessedPoint();
                this.slicedPointAndLineChanges.updatePointTags(point.getIdentifier(), this.createPointTags(location, true));
            }
        }
    }

    private void updateLineToHaveCountryCodesFromAllSlices(Line line, List<Geometry> slices) {
        HashMap<String, String> tags = new HashMap<String, String>();
        Set allCountries = slices.stream().map(geometry -> CountryBoundaryMap.getGeometryProperty(geometry, "iso_country_code")).collect(Collectors.toCollection(TreeSet::new));
        String countryString = Joiner.on(",").join(allCountries);
        tags.put("iso_country_code", countryString);
        this.slicedPointAndLineChanges.updateLineTags(line.getIdentifier(), tags);
        this.updateLineShapePoints(line);
    }
}

