/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.geography.atlas.raw.slicing;

import java.util.HashSet;
import java.util.Set;
import org.openstreetmap.atlas.geography.atlas.Atlas;
import org.openstreetmap.atlas.geography.atlas.raw.slicing.CoordinateToNewPointMapping;
import org.openstreetmap.atlas.geography.atlas.raw.slicing.RawAtlasPointAndLineSlicer;
import org.openstreetmap.atlas.geography.atlas.raw.slicing.RawAtlasRelationSlicer;
import org.openstreetmap.atlas.geography.atlas.raw.slicing.RawAtlasSlicer;
import org.openstreetmap.atlas.geography.atlas.raw.slicing.changeset.RelationChangeSet;
import org.openstreetmap.atlas.geography.atlas.raw.slicing.changeset.SimpleChangeSet;
import org.openstreetmap.atlas.geography.boundary.CountryBoundaryMap;
import org.openstreetmap.atlas.utilities.time.Time;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RawAtlasCountrySlicer {
    private static final Logger logger = LoggerFactory.getLogger(RawAtlasCountrySlicer.class);
    private final CountryBoundaryMap countryBoundaryMap;
    private final Set<String> countries = new HashSet<String>();

    public RawAtlasCountrySlicer(Set<String> countries, CountryBoundaryMap countryBoundaryMap) {
        this.countries.addAll(countries);
        this.countryBoundaryMap = countryBoundaryMap;
    }

    public RawAtlasCountrySlicer(String country, CountryBoundaryMap countryBoundaryMap) {
        this.countries.add(country);
        this.countryBoundaryMap = countryBoundaryMap;
    }

    public Atlas slice(Atlas rawAtlas) {
        Time time = Time.now();
        String shardName = this.getShardOrAtlasName(rawAtlas);
        logger.info("Started all Slicing for Shard {}", (Object)shardName);
        SimpleChangeSet slicedPointAndLineChanges = new SimpleChangeSet();
        RelationChangeSet slicedRelationChanges = new RelationChangeSet();
        CoordinateToNewPointMapping newPointCoordinates = new CoordinateToNewPointMapping();
        RawAtlasPointAndLineSlicer pointAndLineSlicer = new RawAtlasPointAndLineSlicer(this.countries, this.countryBoundaryMap, rawAtlas, slicedPointAndLineChanges, newPointCoordinates);
        Atlas slicedPointsAndLinesAtlas = ((RawAtlasSlicer)pointAndLineSlicer).slice();
        RawAtlasRelationSlicer relationSlicer = new RawAtlasRelationSlicer(slicedPointsAndLinesAtlas, this.countries, this.countryBoundaryMap, slicedPointAndLineChanges, slicedRelationChanges, newPointCoordinates);
        logger.info("Finished all Slicing for Shard {} in {}", (Object)shardName, (Object)time.elapsedSince());
        return ((RawAtlasSlicer)relationSlicer).slice();
    }

    private String getShardOrAtlasName(Atlas atlas) {
        return atlas.metaData().getShardName().orElse(atlas.getName());
    }
}

