/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.geography.atlas.pbf.slicing;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.openstreetmap.atlas.geography.atlas.pbf.slicing.identifier.AbstractIdentifierFactory;
import org.openstreetmap.atlas.geography.atlas.pbf.slicing.identifier.WaySectionIdentifierFactory;
import org.openstreetmap.atlas.geography.atlas.pbf.store.PbfMemoryStore;
import org.openstreetmap.atlas.geography.atlas.pbf.store.PbfOneWay;
import org.openstreetmap.atlas.geography.atlas.pbf.store.SectionCounter;
import org.openstreetmap.atlas.geography.atlas.pbf.store.TagMap;
import org.openstreetmap.atlas.tags.Taggable;
import org.openstreetmap.osmosis.core.domain.v0_6.EntityType;
import org.openstreetmap.osmosis.core.domain.v0_6.Node;
import org.openstreetmap.osmosis.core.domain.v0_6.Relation;
import org.openstreetmap.osmosis.core.domain.v0_6.RelationMember;
import org.openstreetmap.osmosis.core.domain.v0_6.Way;
import org.openstreetmap.osmosis.core.domain.v0_6.WayNode;

public class WaySectionProcessor {
    private final SectionCounter countForNode = new SectionCounter();
    private final PbfMemoryStore store;
    private AbstractIdentifierFactory identifierFactory;

    public WaySectionProcessor(PbfMemoryStore store) {
        this.store = store;
        this.identifierFactory = null;
    }

    public void run() {
        this.store.forEachAtlasEdge(way -> way.getWayNodes().forEach(this.countForNode::increment));
        this.store.forEachNode((identifier, node) -> {
            if (this.shouldSectionNode((Node)node)) {
                this.countForNode.increment((Long)identifier);
            }
        });
        HashMap<Long, List> waysNeedingUpdate = new HashMap<Long, List>(this.store.wayCount(), 1.0f);
        this.store.forEachAtlasEdge(way -> {
            List<Way> sectionedWays;
            if ((long)(this.numberOfSlicingPoints((Way)way) + 1) < 1000L && (sectionedWays = this.splitWay((Way)way)).size() != 0) {
                waysNeedingUpdate.put(way.getId(), sectionedWays);
            }
        });
        this.countForNode.sections().forEach(nodeIdentifier -> this.store.addNodeAtEndOfEdge((long)nodeIdentifier));
        waysNeedingUpdate.forEach((oldIdentifier, newWays) -> {
            this.store.removeWay((long)oldIdentifier);
            newWays.forEach(this.store::addWay);
        });
        HashMap<Long, Relation> modified = new HashMap<Long, Relation>();
        this.store.forEachRelation((identifier, relation) -> {
            Set<Long> toUpdate = this.checkRelation((Map<Long, List<Way>>)waysNeedingUpdate, (Relation)relation);
            if (toUpdate.size() != 0) {
                modified.put((Long)identifier, this.createNew((Map<Long, List<Way>>)waysNeedingUpdate, (Relation)relation, toUpdate));
            }
        });
        modified.forEach((oldIdentifier, newRelation) -> {
            this.store.removeRelation((long)oldIdentifier);
            this.store.addRelation((Relation)newRelation);
        });
    }

    private void addSplitWay(List<Way> splitWays, Way splitWay) {
        splitWays.add(splitWay);
    }

    private Set<Long> checkRelation(Map<Long, List<Way>> splitWays, Relation relation) {
        HashSet<Long> results = new HashSet<Long>();
        for (RelationMember member : relation.getMembers()) {
            if (!splitWays.containsKey(member.getMemberId())) continue;
            results.add(member.getMemberId());
        }
        return results;
    }

    private Relation createNew(Map<Long, List<Way>> splitWays, Relation reference, Set<Long> needUpdate) {
        List<RelationMember> oldMembers = reference.getMembers();
        ArrayList<RelationMember> newMembers = new ArrayList<RelationMember>(oldMembers.size());
        for (RelationMember member : oldMembers) {
            long identifier = member.getMemberId();
            if (needUpdate.contains(identifier)) {
                splitWays.get(identifier).forEach(way -> newMembers.add(new RelationMember(way.getId(), EntityType.Way, member.getMemberRole())));
                continue;
            }
            newMembers.add(member);
        }
        return this.store.createRelation(reference, reference.getId(), newMembers);
    }

    private int numberOfSlicingPoints(Way way) {
        int count = 0;
        List<WayNode> wayNodes = way.getWayNodes();
        for (int index = 1; index < wayNodes.size() - 1; ++index) {
            if (!this.countForNode.isSection(wayNodes.get(index).getNodeId())) continue;
            ++count;
        }
        return count;
    }

    private boolean shouldSectionNode(Node node) {
        Taggable taggableNode = Taggable.with(node.getTags());
        return this.store.getAtlasLoadingOption().getWaySectionFilter().test(taggableNode);
    }

    private List<Way> splitWay(Way way) {
        ArrayList<Way> splitWays = new ArrayList<Way>();
        this.identifierFactory = new WaySectionIdentifierFactory(way.getId());
        List<WayNode> wayNodes = way.getWayNodes();
        boolean split = false;
        PbfOneWay oneWay = new TagMap(way.getTags()).getOneWay();
        if (oneWay != PbfOneWay.REVERSED) {
            int lastIndex = 0;
            for (int currentIndex = 1; currentIndex < wayNodes.size() - 1; ++currentIndex) {
                if (!this.countForNode.isSection(wayNodes.get(currentIndex).getNodeId())) continue;
                split = true;
                Way splitWay = this.store.createWay(way, this.identifierFactory.nextIdentifier(), wayNodes.subList(lastIndex, currentIndex + 1));
                this.addSplitWay(splitWays, splitWay);
                lastIndex = currentIndex;
            }
            if (split) {
                Way splitWay = this.store.createWay(way, this.identifierFactory.nextIdentifier(), wayNodes.subList(lastIndex, wayNodes.size()));
                this.addSplitWay(splitWays, splitWay);
            }
        } else {
            int lastIndex = wayNodes.size();
            for (int currentIndex = wayNodes.size() - 2; currentIndex > 0; --currentIndex) {
                if (!this.countForNode.isSection(wayNodes.get(currentIndex).getNodeId())) continue;
                split = true;
                Way splitWay = this.store.createWay(way, this.identifierFactory.nextIdentifier(), wayNodes.subList(currentIndex, lastIndex));
                this.addSplitWay(splitWays, splitWay);
                lastIndex = currentIndex + 1;
            }
            if (split) {
                Way splitWay = this.store.createWay(way, this.identifierFactory.nextIdentifier(), wayNodes.subList(0, lastIndex));
                this.addSplitWay(splitWays, splitWay);
            }
        }
        return splitWays;
    }
}

