/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.geography.atlas.multi;

import com.google.common.collect.Sets;
import java.util.AbstractSet;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.openstreetmap.atlas.geography.Location;
import org.openstreetmap.atlas.geography.atlas.items.Point;
import org.openstreetmap.atlas.geography.atlas.items.Relation;
import org.openstreetmap.atlas.geography.atlas.multi.MultiAtlas;
import org.openstreetmap.atlas.geography.atlas.multi.SubPointList;

public class MultiPoint
extends Point {
    private static final long serialVersionUID = 209103872813085178L;
    private final long identifier;
    private SubPointList subPoints;

    protected MultiPoint(MultiAtlas atlas, long identifier) {
        super(atlas);
        this.identifier = identifier;
    }

    @Override
    public long getIdentifier() {
        return this.identifier;
    }

    @Override
    public Location getLocation() {
        return this.getRepresentativeSubPoint().getLocation();
    }

    public SubPointList getSubPoints() {
        if (this.subPoints == null) {
            this.subPoints = this.multiAtlas().subPoints(this.identifier);
        }
        return this.subPoints;
    }

    @Override
    public Map<String, String> getTags() {
        return this.getRepresentativeSubPoint().getTags();
    }

    @Override
    public Set<Relation> relations() {
        AbstractSet unionOfAllParentRelations = new HashSet<Relation>();
        for (Point subPoint : this.getSubPoints().getSubPoints()) {
            Set<Relation> currentSubPointParentRelations = this.multiAtlas().multifyRelations(subPoint);
            unionOfAllParentRelations = Sets.union(unionOfAllParentRelations, currentSubPointParentRelations);
        }
        return unionOfAllParentRelations;
    }

    private Point getRepresentativeSubPoint() {
        return this.getSubPoints().getSubPoints().get(0);
    }

    private MultiAtlas multiAtlas() {
        return (MultiAtlas)this.getAtlas();
    }
}

