/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.geography.atlas.items.complex.waters.handler;

import java.util.Arrays;
import java.util.List;
import org.openstreetmap.atlas.geography.atlas.items.AtlasEntity;
import org.openstreetmap.atlas.geography.atlas.items.ItemType;
import org.openstreetmap.atlas.geography.atlas.items.complex.waters.WaterType;
import org.openstreetmap.atlas.geography.atlas.items.complex.waters.handler.AbstractWaterHandler;
import org.openstreetmap.atlas.tags.HarbourTag;
import org.openstreetmap.atlas.tags.IndustrialTag;
import org.openstreetmap.atlas.tags.LandUseTag;
import org.openstreetmap.atlas.tags.Taggable;
import org.openstreetmap.atlas.tags.annotations.validation.Validators;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HarbourHandler
extends AbstractWaterHandler {
    private static final Logger logger = LoggerFactory.getLogger(HarbourHandler.class);

    public static boolean isHarbour(AtlasEntity entity) {
        return Validators.isOfType((Taggable)entity, HarbourTag.class, (Enum[])new HarbourTag[]{HarbourTag.YES}) && !Validators.isOfType((Taggable)entity, LandUseTag.class, (Enum[])new LandUseTag[]{LandUseTag.INDUSTRIAL, LandUseTag.PORT}) && !Validators.isOfType((Taggable)entity, IndustrialTag.class, (Enum[])new IndustrialTag[]{IndustrialTag.PORT, IndustrialTag.SHIPYARD});
    }

    @Override
    public boolean canHandle(AtlasEntity entity) {
        return HarbourHandler.isHarbour(entity);
    }

    @Override
    public List<ItemType> getAllowedTypes() {
        return Arrays.asList(ItemType.AREA, ItemType.RELATION);
    }

    @Override
    public Logger getLogger() {
        return logger;
    }

    @Override
    public WaterType getType() {
        return WaterType.HARBOUR;
    }
}

