/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.geography.atlas.items.complex.waters;

import org.openstreetmap.atlas.exception.CoreException;
import org.openstreetmap.atlas.geography.MultiPolygon;
import org.openstreetmap.atlas.geography.atlas.items.Area;
import org.openstreetmap.atlas.geography.atlas.items.AtlasEntity;
import org.openstreetmap.atlas.geography.atlas.items.Relation;
import org.openstreetmap.atlas.geography.atlas.items.complex.RelationOrAreaToMultiPolygonConverter;
import org.openstreetmap.atlas.geography.atlas.items.complex.waters.ComplexWaterEntity;
import org.openstreetmap.atlas.geography.atlas.items.complex.waters.WaterType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ComplexWaterbody
extends ComplexWaterEntity {
    private static final long serialVersionUID = -666543090371777011L;
    private static final RelationOrAreaToMultiPolygonConverter RELATION_OR_AREA_TO_MULTI_POLYGON_CONVERTER = new RelationOrAreaToMultiPolygonConverter();
    private static final Logger logger = LoggerFactory.getLogger(ComplexWaterbody.class);
    private MultiPolygon geometry;

    public ComplexWaterbody(AtlasEntity source, WaterType type) {
        super(source, type);
    }

    public MultiPolygon getGeometry() {
        return this.geometry;
    }

    @Override
    protected Logger getLogger() {
        return logger;
    }

    @Override
    protected void populateGeometry() {
        Relation relation;
        String type;
        AtlasEntity source = this.getSource();
        if (source instanceof Area) {
            this.geometry = RELATION_OR_AREA_TO_MULTI_POLYGON_CONVERTER.convert(source);
            return;
        }
        if (source instanceof Relation && "multipolygon".equals(type = (relation = (Relation)source).tag("type"))) {
            this.geometry = RELATION_OR_AREA_TO_MULTI_POLYGON_CONVERTER.convert(relation);
            return;
        }
        throw new CoreException("Geometry is not set for {}", source);
    }
}

