/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.geography.atlas.items;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.openstreetmap.atlas.exception.CoreException;
import org.openstreetmap.atlas.geography.Located;
import org.openstreetmap.atlas.geography.Rectangle;
import org.openstreetmap.atlas.geography.atlas.items.AtlasItem;
import org.openstreetmap.atlas.geography.atlas.items.Edge;
import org.openstreetmap.atlas.geography.atlas.items.Node;
import org.openstreetmap.atlas.geography.atlas.items.Relation;
import org.openstreetmap.atlas.geography.atlas.items.RelationMember;
import org.openstreetmap.atlas.geography.atlas.items.Route;
import org.openstreetmap.atlas.geography.geojson.GeoJsonBuilder;
import org.openstreetmap.atlas.tags.TurnRestrictionTag;
import org.openstreetmap.atlas.utilities.collections.Maps;
import org.openstreetmap.atlas.utilities.collections.StringList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class TurnRestriction
implements Located,
Serializable {
    private static final Logger logger = LoggerFactory.getLogger(TurnRestriction.class);
    private static final long serialVersionUID = 7043701090121113526L;
    private Route from;
    private final Relation relation;
    private Route route;
    private Route too;
    private TurnRestrictionType type;
    private Route via;

    public static Optional<TurnRestriction> from(Relation relation) {
        TurnRestriction turnRestriction = new TurnRestriction(relation);
        if (turnRestriction.isValid()) {
            return Optional.of(turnRestriction);
        }
        return Optional.empty();
    }

    public static TurnRestrictionType getTurnRestrictionType(Relation relation) {
        if (TurnRestrictionTag.isNoPathRestriction(relation)) {
            return TurnRestrictionType.NO;
        }
        if (TurnRestrictionTag.isOnlyPathRestriction(relation)) {
            return TurnRestrictionType.ONLY;
        }
        return TurnRestrictionType.OTHER;
    }

    public static boolean isTurnRestriction(Route candidate) {
        for (Edge edge : candidate) {
            Set<Relation> relations = edge.relations();
            block6: for (Relation relation : relations) {
                Optional<TurnRestriction> turnRestrictionOption;
                if (!TurnRestrictionTag.isRestriction(relation) || !(turnRestrictionOption = TurnRestriction.from(relation)).isPresent()) continue;
                TurnRestriction turnRestriction = turnRestrictionOption.get();
                Route path = turnRestriction.route();
                switch (turnRestriction.getTurnRestrictionType()) {
                    case NO: {
                        if (path == null || !candidate.isOverlapping(path) || !TurnRestriction.routeContainsAllTurnRestrictionParts(turnRestriction, candidate)) continue block6;
                        return true;
                    }
                    case ONLY: {
                        int routeEndIndex;
                        int fromSubRouteIndex;
                        Route from;
                        if (path == null || !candidate.isSubRoute(from = turnRestriction.getFrom()) || candidate.isSubRoute(path) || (fromSubRouteIndex = candidate.subRouteIndex(from)) == (routeEndIndex = candidate.size() - 1)) continue block6;
                        Route partialRoute = candidate.subRoute(fromSubRouteIndex + 1, routeEndIndex + 1);
                        if (!turnRestriction.otherToOptions().stream().anyMatch(partialRoute::startsWith)) continue block6;
                        return true;
                    }
                    case OTHER: {
                        logger.trace("Not using Other TurnRestrictionType: {}", (Object)turnRestriction.getTurnRestrictionType());
                        return false;
                    }
                    default: {
                        throw new CoreException("Unknown TurnRestrictionType: {}", new Object[]{turnRestriction.getTurnRestrictionType()});
                    }
                }
            }
        }
        return false;
    }

    private static boolean routeContainsAllTurnRestrictionParts(TurnRestriction turnRestriction, Route route) {
        Optional<Route> possibleVia = turnRestriction.getVia();
        boolean viaMatches = true;
        if (possibleVia.isPresent()) {
            viaMatches = route.isSubRoute(possibleVia.get());
        }
        return viaMatches && route.isSubRoute(turnRestriction.getTo()) && route.isSubRoute(turnRestriction.getFrom());
    }

    private TurnRestriction(Relation relation) {
        Route fromMember = null;
        Route viaMember = null;
        Route toMember = null;
        this.relation = relation;
        this.type = TurnRestriction.getTurnRestrictionType(relation);
        if (this.type == TurnRestrictionType.OTHER) {
            this.from = null;
            this.via = null;
            this.too = null;
            return;
        }
        try {
            if (!TurnRestrictionTag.isRestriction(relation)) {
                throw new CoreException("Relation {} is not a restriction.", relation);
            }
            Set viaMembers = relation.members().stream().filter(member -> member.getRole().equals("via")).filter(member -> member.getEntity() instanceof Node || member.getEntity() instanceof Edge).map(RelationMember::getEntity).map(entity -> (AtlasItem)entity).collect(Collectors.toSet());
            long viaNodeCount = viaMembers.stream().filter(atlasItem -> atlasItem instanceof Node).count();
            if (viaNodeCount > 1L) {
                throw new CoreException("Restriction relation should not have more than 1 via node. But, {} has {} via nodes", relation.getOsmIdentifier(), viaNodeCount);
            }
            HashSet temporaryToMembers = new HashSet();
            if (viaMembers.isEmpty()) {
                if (this.isSameRoadViaAndTo(relation)) {
                    throw new CoreException("Relation {} has same members in from and to, but has no via members to disambiguate.", relation.getIdentifier());
                }
                relation.members().stream().filter(member -> member.getRole().equals("to")).forEach(member -> temporaryToMembers.add((AtlasItem)member.getEntity()));
            }
            TreeSet<Edge> fromMembers = new TreeSet<Edge>();
            relation.members().stream().filter(member -> member.getRole().equals("from") && member.getEntity() instanceof Edge && (!viaMembers.isEmpty() && ((Edge)member.getEntity()).isConnectedAtEndTo(viaMembers) || ((Edge)member.getEntity()).isConnectedAtEndTo(temporaryToMembers))).forEach(member -> fromMembers.add((Edge)member.getEntity()));
            fromMember = Route.fromNonArrangedEdgeSet(fromMembers, false);
            TreeSet<Edge> toMembers = new TreeSet<Edge>();
            relation.members().stream().filter(member -> member.getRole().equals("to") && member.getEntity() instanceof Edge && (!viaMembers.isEmpty() && ((Edge)member.getEntity()).isConnectedAtStartTo(viaMembers) || ((Edge)member.getEntity()).isConnectedAtStartTo(fromMembers))).forEach(member -> toMembers.add((Edge)member.getEntity()));
            toMember = Route.fromNonArrangedEdgeSet(toMembers, false);
            Set<Edge> viaEdges = viaMembers.stream().filter(member -> member instanceof Edge).map(member -> (Edge)member).collect(Collectors.toSet());
            if (!viaEdges.isEmpty()) {
                viaMember = Route.buildFullRouteIgnoringReverseEdges(viaEdges, fromMember.end().end(), toMember.start().start());
            }
        }
        catch (CoreException e) {
            logger.trace("Could not build TurnRestriction from relation {}", (Object)relation, (Object)e);
            fromMember = null;
            viaMember = null;
            toMember = null;
        }
        this.from = fromMember;
        this.via = viaMember;
        this.too = toMember;
    }

    public GeoJsonBuilder.LocationIterableProperties asGeoJson() {
        Map<String, String> tagsNo = Maps.hashMap("highway", "primary", "oneway", "yes", "type", "NO");
        Map<String, String> tagsOnly = Maps.hashMap("highway", "primary", "oneway", "yes", "type", "ONLY");
        return new GeoJsonBuilder.LocationIterableProperties(this.route().asPolyLine(), this.getTurnRestrictionType() == TurnRestrictionType.NO ? tagsNo : tagsOnly);
    }

    @Override
    public Rectangle bounds() {
        if (!this.isValid()) {
            throw new CoreException("An invalid TurnRestriction cannot be Located.");
        }
        return this.route().bounds();
    }

    public Route getFrom() {
        return this.from;
    }

    public Route getTo() {
        return this.too;
    }

    public TurnRestrictionType getTurnRestrictionType() {
        return this.type;
    }

    public Optional<Route> getVia() {
        return Optional.ofNullable(this.via);
    }

    public Route route() {
        if (this.route == null) {
            ArrayList<Route> routes = new ArrayList<Route>();
            if (this.from != null) {
                routes.add(this.from);
            }
            if (this.via != null) {
                routes.add(this.via);
            }
            if (this.too != null) {
                routes.add(this.too);
            }
            try {
                this.route = Route.forRoutes(routes);
            }
            catch (Exception e) {
                logger.trace("Can't build route from {}", (Object)this.relation, (Object)e);
            }
        }
        return this.route;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("[");
        builder.append(this.type.toString());
        builder.append(": ");
        if (this.from != null) {
            StringList froms = new StringList();
            this.from.forEach(edge -> froms.add(String.valueOf(edge.getIdentifier())));
            builder.append(froms.join(","));
        }
        builder.append("_");
        if (this.via != null) {
            StringList vias = new StringList();
            this.via.forEach(edge -> vias.add(String.valueOf(edge.getIdentifier())));
            builder.append(vias.join(","));
        }
        builder.append("_");
        if (this.too != null) {
            StringList tos = new StringList();
            this.too.forEach(edge -> tos.add(String.valueOf(edge.getIdentifier())));
            builder.append(tos.join(","));
        }
        builder.append("]");
        return builder.toString();
    }

    protected Set<Route> otherToOptions() {
        HashSet<Route> result = new HashSet<Route>();
        for (Edge toEdge : this.too.start().start().outEdges()) {
            if (toEdge.equals(this.too.start())) continue;
            result.add(Route.forEdge(toEdge));
        }
        return result;
    }

    private boolean isSameRoadViaAndTo(Relation relation) {
        TreeSet fromIdentifiers = new TreeSet();
        TreeSet toIdentifiers = new TreeSet();
        relation.members().stream().filter(member -> "to".equals(member.getRole())).forEach(member -> toIdentifiers.add(member.getEntity().getIdentifier()));
        relation.members().stream().filter(member -> "from".equals(member.getRole())).forEach(member -> fromIdentifiers.add(member.getEntity().getIdentifier()));
        return fromIdentifiers.equals(toIdentifiers);
    }

    private boolean isValid() {
        return this.from != null && this.too != null && this.route() != null;
    }

    public static enum TurnRestrictionType {
        NO,
        ONLY,
        OTHER;

    }
}

