/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.geography.atlas.dynamic;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.openstreetmap.atlas.exception.CoreException;
import org.openstreetmap.atlas.geography.atlas.dynamic.DynamicArea;
import org.openstreetmap.atlas.geography.atlas.dynamic.DynamicAtlas;
import org.openstreetmap.atlas.geography.atlas.dynamic.DynamicEdge;
import org.openstreetmap.atlas.geography.atlas.dynamic.DynamicLine;
import org.openstreetmap.atlas.geography.atlas.dynamic.DynamicNode;
import org.openstreetmap.atlas.geography.atlas.dynamic.DynamicPoint;
import org.openstreetmap.atlas.geography.atlas.items.AtlasEntity;
import org.openstreetmap.atlas.geography.atlas.items.Relation;
import org.openstreetmap.atlas.geography.atlas.items.RelationMember;
import org.openstreetmap.atlas.geography.atlas.items.RelationMemberList;

public class DynamicRelation
extends Relation {
    private static final long serialVersionUID = 7994622214805021474L;
    private final long identifier;

    protected DynamicRelation(DynamicAtlas atlas, long identifier) {
        super(atlas);
        this.identifier = identifier;
    }

    @Override
    public RelationMemberList allKnownOsmMembers() {
        return this.getRelationMembersAsDynamicEntities(this.subRelation().allKnownOsmMembers());
    }

    @Override
    public List<Relation> allRelationsWithSameOsmIdentifier() {
        return this.subRelation().allRelationsWithSameOsmIdentifier().stream().map(relation -> new DynamicRelation(this.dynamicAtlas(), relation.getIdentifier())).collect(Collectors.toList());
    }

    @Override
    public long getIdentifier() {
        return this.identifier;
    }

    @Override
    public Map<String, String> getTags() {
        return this.subRelation().getTags();
    }

    @Override
    public RelationMemberList members() {
        return this.getRelationMembersAsDynamicEntities(this.subRelation().members());
    }

    @Override
    public long osmRelationIdentifier() {
        return this.subRelation().osmRelationIdentifier();
    }

    @Override
    public Set<Relation> relations() {
        return this.subRelation().relations().stream().map(relation -> new DynamicRelation(this.dynamicAtlas(), relation.getIdentifier())).collect(Collectors.toSet());
    }

    private DynamicAtlas dynamicAtlas() {
        return (DynamicAtlas)this.getAtlas();
    }

    private RelationMemberList getRelationMembersAsDynamicEntities(RelationMemberList memberList) {
        ArrayList<RelationMember> newMemberList = new ArrayList<RelationMember>();
        for (RelationMember member : memberList) {
            AtlasEntity entity = member.getEntity();
            AtlasEntity dynamicEntity = null;
            switch (entity.getType()) {
                case NODE: {
                    dynamicEntity = new DynamicNode(this.dynamicAtlas(), entity.getIdentifier());
                    break;
                }
                case EDGE: {
                    dynamicEntity = new DynamicEdge(this.dynamicAtlas(), entity.getIdentifier());
                    break;
                }
                case POINT: {
                    dynamicEntity = new DynamicPoint(this.dynamicAtlas(), entity.getIdentifier());
                    break;
                }
                case LINE: {
                    dynamicEntity = new DynamicLine(this.dynamicAtlas(), entity.getIdentifier());
                    break;
                }
                case AREA: {
                    dynamicEntity = new DynamicArea(this.dynamicAtlas(), entity.getIdentifier());
                    break;
                }
                case RELATION: {
                    dynamicEntity = new DynamicRelation(this.dynamicAtlas(), entity.getIdentifier());
                    break;
                }
                default: {
                    throw new CoreException("Invalid entity type {}", new Object[]{entity.getType()});
                }
            }
            newMemberList.add(new RelationMember(member.getRole(), dynamicEntity, member.getRelationIdentifier()));
        }
        return new RelationMemberList(newMemberList);
    }

    private Relation subRelation() {
        Relation result = this.dynamicAtlas().subRelation(this.identifier);
        if (result != null) {
            return result;
        }
        throw new CoreException("DynamicAtlas {} moved too fast! {} {} is missing now.", this.dynamicAtlas().getName(), this.getClass().getSimpleName(), this.identifier);
    }
}

