/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.geography.atlas.dynamic;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.openstreetmap.atlas.exception.CoreException;
import org.openstreetmap.atlas.geography.Location;
import org.openstreetmap.atlas.geography.MultiPolygon;
import org.openstreetmap.atlas.geography.PolyLine;
import org.openstreetmap.atlas.geography.Polygon;
import org.openstreetmap.atlas.geography.Rectangle;
import org.openstreetmap.atlas.geography.atlas.Atlas;
import org.openstreetmap.atlas.geography.atlas.AtlasMetaData;
import org.openstreetmap.atlas.geography.atlas.BareAtlas;
import org.openstreetmap.atlas.geography.atlas.dynamic.DynamicArea;
import org.openstreetmap.atlas.geography.atlas.dynamic.DynamicEdge;
import org.openstreetmap.atlas.geography.atlas.dynamic.DynamicLine;
import org.openstreetmap.atlas.geography.atlas.dynamic.DynamicNode;
import org.openstreetmap.atlas.geography.atlas.dynamic.DynamicPoint;
import org.openstreetmap.atlas.geography.atlas.dynamic.DynamicRelation;
import org.openstreetmap.atlas.geography.atlas.dynamic.policy.DynamicAtlasPolicy;
import org.openstreetmap.atlas.geography.atlas.items.Area;
import org.openstreetmap.atlas.geography.atlas.items.AtlasEntity;
import org.openstreetmap.atlas.geography.atlas.items.Edge;
import org.openstreetmap.atlas.geography.atlas.items.Line;
import org.openstreetmap.atlas.geography.atlas.items.LineItem;
import org.openstreetmap.atlas.geography.atlas.items.LocationItem;
import org.openstreetmap.atlas.geography.atlas.items.Node;
import org.openstreetmap.atlas.geography.atlas.items.Point;
import org.openstreetmap.atlas.geography.atlas.items.Relation;
import org.openstreetmap.atlas.geography.atlas.items.RelationMember;
import org.openstreetmap.atlas.geography.atlas.items.RelationMemberList;
import org.openstreetmap.atlas.geography.atlas.multi.MultiAtlas;
import org.openstreetmap.atlas.geography.sharding.Shard;
import org.openstreetmap.atlas.geography.sharding.Sharding;
import org.openstreetmap.atlas.streaming.resource.WritableResource;
import org.openstreetmap.atlas.utilities.collections.Iterables;
import org.openstreetmap.atlas.utilities.collections.StreamIterable;
import org.openstreetmap.atlas.utilities.collections.StringList;
import org.openstreetmap.atlas.utilities.time.Time;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DynamicAtlas
extends BareAtlas {
    private static final long serialVersionUID = -2858997785405677961L;
    private static final Logger logger = LoggerFactory.getLogger(DynamicAtlas.class);
    private Atlas current;
    private Set<Shard> shardsUsedForCurrent;
    private final Map<Shard, Atlas> loadedShards;
    private final Function<Shard, Optional<Atlas>> atlasFetcher;
    private final Sharding sharding;
    private final DynamicAtlasPolicy policy;
    private final boolean initialized;
    private boolean isAlreadyLoaded = false;
    private boolean preemptiveLoadDone = false;
    private int timesMultiAtlasWasBuiltUnderneath;

    public DynamicAtlas(DynamicAtlasPolicy dynamicAtlasExpansionPolicy) {
        this.setName("DynamicAtlas(" + dynamicAtlasExpansionPolicy.getInitialShards().stream().map(Shard::getName).collect(Collectors.toSet()) + ")");
        this.timesMultiAtlasWasBuiltUnderneath = 0;
        this.sharding = dynamicAtlasExpansionPolicy.getSharding();
        this.loadedShards = new HashMap<Shard, Atlas>();
        this.shardsUsedForCurrent = new HashSet<Shard>();
        this.atlasFetcher = dynamicAtlasExpansionPolicy.getAtlasFetcher();
        this.policy = dynamicAtlasExpansionPolicy;
        this.addNewShards(dynamicAtlasExpansionPolicy.getInitialShards());
        this.initialized = true;
    }

    @Override
    public Area area(long identifier) {
        Iterator<DynamicArea> result = this.expand(() -> Iterables.from(this.subArea(identifier)), this::areaCovered, this::newArea).iterator();
        return result.hasNext() ? (Area)result.next() : null;
    }

    @Override
    public Iterable<Area> areas() {
        return this.expand(() -> this.current.areas(), this::areaCovered, this::newArea);
    }

    @Override
    public Iterable<Area> areasCovering(Location location) {
        return this.expand(() -> this.current.areasCovering(location), this::areaCovered, this::newArea);
    }

    @Override
    public Iterable<Area> areasCovering(Location location, Predicate<Area> matcher) {
        return this.expand(() -> this.current.areasCovering(location, matcher), this::areaCovered, this::newArea);
    }

    @Override
    public Iterable<Area> areasIntersecting(Polygon polygon) {
        return this.expand(() -> this.current.areasIntersecting(polygon), this::areaCovered, this::newArea);
    }

    @Override
    public Iterable<Area> areasIntersecting(Polygon polygon, Predicate<Area> matcher) {
        return this.expand(() -> this.current.areasIntersecting(polygon, matcher), this::areaCovered, this::newArea);
    }

    @Override
    public Rectangle bounds() {
        return this.current.bounds();
    }

    public void buildUnderlyingMultiAtlas() {
        Time buildTime = Time.now();
        Set<Shard> nonNullShards = this.nonNullShards();
        if (this.shardsUsedForCurrent.equals(nonNullShards)) {
            return;
        }
        List<Atlas> nonNullAtlasShards = this.getNonNullAtlasShards();
        if (!nonNullAtlasShards.isEmpty()) {
            this.policy.getShardSetChecker().accept(this.nonNullShards());
            if (nonNullAtlasShards.size() == 1) {
                this.current = nonNullAtlasShards.get(0);
            } else {
                if (logger.isDebugEnabled()) {
                    logger.debug("{}: Loading MultiAtlas with {}", (Object)this.getName(), this.nonNullShards().stream().map(Shard::getName).collect(Collectors.toList()));
                }
                this.current = new MultiAtlas(nonNullAtlasShards);
                ++this.timesMultiAtlasWasBuiltUnderneath;
            }
            this.shardsUsedForCurrent = nonNullShards;
            if (this.initialized) {
                this.isAlreadyLoaded = true;
            }
        } else {
            throw new CoreException("Cannot load shards with no data!");
        }
        logger.trace("{}: Built underlying MultiAtlas in {}", (Object)this.getName(), (Object)buildTime.elapsedSince());
    }

    @Override
    public Edge edge(long identifier) {
        Iterator<DynamicEdge> result = this.expand(() -> Iterables.from(this.subEdge(identifier)), this::lineItemCovered, this::newEdge).iterator();
        return result.hasNext() ? (Edge)result.next() : null;
    }

    @Override
    public Iterable<Edge> edges() {
        return this.expand(() -> this.current.edges(), this::lineItemCovered, this::newEdge);
    }

    @Override
    public Iterable<Edge> edgesContaining(Location location) {
        return this.expand(() -> this.current.edgesContaining(location), this::lineItemCovered, this::newEdge);
    }

    @Override
    public Iterable<Edge> edgesContaining(Location location, Predicate<Edge> matcher) {
        return this.expand(() -> this.current.edgesContaining(location, matcher), this::lineItemCovered, this::newEdge);
    }

    @Override
    public Iterable<Edge> edgesIntersecting(Polygon polygon) {
        return this.expand(() -> this.current.edgesIntersecting(polygon), this::lineItemCovered, this::newEdge);
    }

    @Override
    public Iterable<Edge> edgesIntersecting(Polygon polygon, Predicate<Edge> matcher) {
        return this.expand(() -> this.current.edgesIntersecting(polygon, matcher), this::lineItemCovered, this::newEdge);
    }

    public int getTimesMultiAtlasWasBuiltUnderneath() {
        return this.timesMultiAtlasWasBuiltUnderneath;
    }

    @Override
    public Line line(long identifier) {
        Iterator<DynamicLine> result = this.expand(() -> Iterables.from(this.subLine(identifier)), this::lineItemCovered, this::newLine).iterator();
        return result.hasNext() ? (Line)result.next() : null;
    }

    @Override
    public Iterable<Line> lines() {
        return this.expand(() -> this.current.lines(), this::lineItemCovered, this::newLine);
    }

    @Override
    public Iterable<Line> linesContaining(Location location) {
        return this.expand(() -> this.current.linesContaining(location), this::lineItemCovered, this::newLine);
    }

    @Override
    public Iterable<Line> linesContaining(Location location, Predicate<Line> matcher) {
        return this.expand(() -> this.current.linesContaining(location, matcher), this::lineItemCovered, this::newLine);
    }

    @Override
    public Iterable<Line> linesIntersecting(Polygon polygon) {
        return this.expand(() -> this.current.linesIntersecting(polygon), this::lineItemCovered, this::newLine);
    }

    @Override
    public Iterable<Line> linesIntersecting(Polygon polygon, Predicate<Line> matcher) {
        return this.expand(() -> this.current.linesIntersecting(polygon, matcher), this::lineItemCovered, this::newLine);
    }

    @Override
    public AtlasMetaData metaData() {
        return this.current.metaData();
    }

    @Override
    public Node node(long identifier) {
        Iterator<DynamicNode> result = this.expand(() -> Iterables.from(this.subNode(identifier)), this::locationItemCovered, this::newNode).iterator();
        return result.hasNext() ? (Node)result.next() : null;
    }

    @Override
    public Iterable<Node> nodes() {
        return this.expand(() -> this.current.nodes(), this::locationItemCovered, this::newNode);
    }

    @Override
    public Iterable<Node> nodesAt(Location location) {
        return this.expand(() -> this.current.nodesAt(location), this::locationItemCovered, this::newNode);
    }

    @Override
    public Iterable<Node> nodesWithin(Polygon polygon) {
        return this.expand(() -> this.current.nodesWithin(polygon), this::locationItemCovered, this::newNode);
    }

    @Override
    public Iterable<Node> nodesWithin(Polygon polygon, Predicate<Node> matcher) {
        return this.expand(() -> this.current.nodesWithin(polygon, matcher), this::locationItemCovered, this::newNode);
    }

    @Override
    public long numberOfAreas() {
        return this.current.numberOfAreas();
    }

    @Override
    public long numberOfEdges() {
        return this.current.numberOfEdges();
    }

    @Override
    public long numberOfLines() {
        return this.current.numberOfLines();
    }

    @Override
    public long numberOfNodes() {
        return this.current.numberOfNodes();
    }

    @Override
    public long numberOfPoints() {
        return this.current.numberOfPoints();
    }

    @Override
    public long numberOfRelations() {
        return this.current.numberOfRelations();
    }

    @Override
    public Point point(long identifier) {
        Iterator<DynamicPoint> result = this.expand(() -> Iterables.from(this.subPoint(identifier)), this::locationItemCovered, this::newPoint).iterator();
        return result.hasNext() ? (Point)result.next() : null;
    }

    @Override
    public Iterable<Point> points() {
        return this.expand(() -> this.current.points(), this::locationItemCovered, this::newPoint);
    }

    @Override
    public Iterable<Point> pointsAt(Location location) {
        return this.expand(() -> this.current.pointsAt(location), this::locationItemCovered, this::newPoint);
    }

    @Override
    public Iterable<Point> pointsWithin(Polygon polygon) {
        return this.expand(() -> this.current.pointsWithin(polygon), this::locationItemCovered, this::newPoint);
    }

    @Override
    public Iterable<Point> pointsWithin(Polygon polygon, Predicate<Point> matcher) {
        return this.expand(() -> this.current.pointsWithin(polygon, matcher), this::locationItemCovered, this::newPoint);
    }

    public void preemptiveLoad() {
        if (!this.policy.isDeferLoading()) {
            logger.warn("{}: Skipping preemptive loading as it is useful only when the DynamicAtlasPolicy is deferLoading = true.", (Object)this.getName());
            return;
        }
        this.entities();
        this.buildUnderlyingMultiAtlas();
        HashSet<Shard> currentShards = new HashSet<Shard>(this.loadedShards.keySet());
        this.entities();
        while (!this.loadedShards.keySet().equals(currentShards)) {
            if (logger.isInfoEnabled()) {
                HashSet<Shard> missingShards = new HashSet<Shard>(this.loadedShards.keySet());
                missingShards.removeAll(currentShards);
                logger.info("{}: Preemptive load found new unexpected 2nd degree shard(s): {}", (Object)this.getName(), missingShards.stream().map(Shard::getName).collect(Collectors.toList()));
            }
            this.buildUnderlyingMultiAtlas();
            currentShards = new HashSet<Shard>(this.loadedShards.keySet());
            this.entities();
        }
        this.preemptiveLoadDone = true;
    }

    @Override
    public Relation relation(long identifier) {
        Iterator<DynamicRelation> result = this.expand(() -> Iterables.from(this.subRelation(identifier)), this::relationCovered, this::newRelation).iterator();
        return result.hasNext() ? (Relation)result.next() : null;
    }

    @Override
    public Iterable<Relation> relations() {
        return this.expand(() -> this.current.relations(), this::relationCovered, this::newRelation);
    }

    @Override
    public Iterable<Relation> relationsWithEntitiesIntersecting(Polygon polygon) {
        return this.expand(() -> this.current.relationsWithEntitiesIntersecting(polygon), this::relationCovered, this::newRelation);
    }

    @Override
    public Iterable<Relation> relationsWithEntitiesIntersecting(Polygon polygon, Predicate<Relation> matcher) {
        return this.expand(() -> this.current.relationsWithEntitiesIntersecting(polygon, matcher), this::relationCovered, this::newRelation);
    }

    @Override
    public void save(WritableResource writableResource) {
        throw new CoreException("DynamicAtlas cannot be saved");
    }

    protected Area subArea(long identifier) {
        return this.current.area(identifier);
    }

    protected Edge subEdge(long identifier) {
        return this.current.edge(identifier);
    }

    protected Line subLine(long identifier) {
        return this.current.line(identifier);
    }

    protected Node subNode(long identifier) {
        return this.current.node(identifier);
    }

    protected Point subPoint(long identifier) {
        return this.current.point(identifier);
    }

    protected Relation subRelation(long identifier) {
        return this.current.relation(identifier);
    }

    private void addNewShards(Iterable<? extends Shard> shards) {
        Set<Shard> initialNonEmptyLoadedShards = this.nonNullShards();
        for (Shard shard : shards) {
            if (this.loadedShards.containsKey(shard)) continue;
            this.loadedShards.put(shard, this.atlasFetcher.apply(shard).orElse(null));
            if (!logger.isInfoEnabled()) continue;
            Atlas loaded = this.loadedShards.get(shard);
            if (loaded == null) {
                logger.info("{}: Loading new shard {} found no new Atlas.", (Object)this.getName(), (Object)shard.getName());
                continue;
            }
            logger.info("{}: Loading new shard {} found a new Atlas {} of size {}", new Object[]{this.getName(), shard.getName(), loaded.getName(), loaded.size().toString()});
        }
        List<Atlas> nonNullAtlasShards = this.getNonNullAtlasShards();
        if (!nonNullAtlasShards.isEmpty()) {
            if (!(initialNonEmptyLoadedShards.equals(this.nonNullShards()) || this.initialized && this.policy.isDeferLoading() && !this.isAlreadyLoaded)) {
                this.buildUnderlyingMultiAtlas();
            }
        } else {
            throw new CoreException("{}: There is no data to load for initial shard!", this.getName());
        }
    }

    private boolean areaCovered(Area area) {
        Polygon polygon = area.asPolygon();
        MultiPolygon initialShardsBounds = this.policy.getInitialShardsBounds();
        if (!(this.policy.isExtendIndefinitely() || polygon.overlaps(initialShardsBounds) || initialShardsBounds.overlaps(polygon))) {
            return true;
        }
        Iterable<? extends Shard> neededShards = this.sharding.shards(polygon);
        for (Shard shard : neededShards) {
            if (this.loadedShards.containsKey(shard)) continue;
            this.newPolygon(polygon, area);
            return false;
        }
        return true;
    }

    private <V extends AtlasEntity> boolean entitiesCovered(Iterable<V> entities, Predicate<V> entityCoveredPredicate) {
        return Iterables.stream(entities).filter(entity -> this.policy.getAtlasEntitiesToConsiderForExpansion().test((AtlasEntity)entity)).allMatch(entityCoveredPredicate);
    }

    private <V extends AtlasEntity, T> Iterable<T> expand(Supplier<Iterable<V>> entitiesSupplier, Predicate<V> entityCoveredPredicate, Function<V, T> mapper) {
        boolean shouldStopExploring;
        StreamIterable<AtlasEntity> result = Iterables.stream(entitiesSupplier.get()).filter(Objects::nonNull);
        boolean bl = shouldStopExploring = this.policy.isDeferLoading() && !this.policy.isExtendIndefinitely() && this.preemptiveLoadDone;
        while (!shouldStopExploring && !this.entitiesCovered(result, entityCoveredPredicate)) {
            result = Iterables.stream(entitiesSupplier.get()).filter(Objects::nonNull);
        }
        return result.map(mapper).collect();
    }

    private List<Atlas> getNonNullAtlasShards() {
        return this.loadedShards.values().stream().filter(Objects::nonNull).collect(Collectors.toList());
    }

    private boolean lineItemCovered(LineItem item) {
        PolyLine polyLine = item.asPolyLine();
        MultiPolygon initialShardsBounds = this.policy.getInitialShardsBounds();
        if (!this.policy.isExtendIndefinitely() && !initialShardsBounds.overlaps(polyLine)) {
            return true;
        }
        Iterable<? extends Shard> neededShards = this.sharding.shardsIntersecting(polyLine);
        for (Shard shard : neededShards) {
            if (this.loadedShards.containsKey(shard)) continue;
            this.newPolyLine(polyLine, item);
            return false;
        }
        return true;
    }

    private boolean loadedShardsfullyGeometricallyEncloseLocation(Location location) {
        return Iterables.stream(this.sharding.shardsCovering(location)).allMatch(this.loadedShards::containsKey);
    }

    private boolean loadedShardsfullyGeometricallyEnclosePolygon(Polygon polygon) {
        return Iterables.stream(this.sharding.shards(polygon)).allMatch(this.loadedShards::containsKey);
    }

    private boolean loadedShardsfullyGeometricallyEnclosePolyLine(PolyLine polyLine) {
        return Iterables.stream(this.sharding.shardsIntersecting(polyLine)).allMatch(this.loadedShards::containsKey);
    }

    private boolean locationItemCovered(LocationItem item) {
        Location location = item.getLocation();
        MultiPolygon initialShardsBounds = this.policy.getInitialShardsBounds();
        if (!this.policy.isExtendIndefinitely() && !initialShardsBounds.fullyGeometricallyEncloses(location)) {
            return true;
        }
        Iterable<? extends Shard> neededShards = this.sharding.shardsCovering(location);
        for (Shard shard : neededShards) {
            if (this.loadedShards.containsKey(shard)) continue;
            this.newLocation(location, item);
            return false;
        }
        return true;
    }

    private DynamicArea newArea(Area area) {
        return new DynamicArea(this, area.getIdentifier());
    }

    private DynamicEdge newEdge(Edge edge) {
        return new DynamicEdge(this, edge.getIdentifier());
    }

    private DynamicLine newLine(Line line) {
        return new DynamicLine(this, line.getIdentifier());
    }

    private void newLocation(Location location, LocationItem ... source) {
        if (!this.loadedShardsfullyGeometricallyEncloseLocation(location)) {
            if (logger.isDebugEnabled()) {
                logger.debug("{}: Triggering new shard load for {}{}", new Object[]{this.getName(), source.length > 0 ? "Atlas " + new StringList(Iterables.stream(Iterables.asList(source)).map(item -> (Object)((Object)item.getType()) + " " + item.getIdentifier())).join(", ") + " with shape " : "", location.toWkt()});
            }
            this.addNewShards(this.sharding.shardsCovering(location));
        }
    }

    private DynamicNode newNode(Node node) {
        return new DynamicNode(this, node.getIdentifier());
    }

    private DynamicPoint newPoint(Point point) {
        return new DynamicPoint(this, point.getIdentifier());
    }

    private void newPolygon(Polygon polygon, AtlasEntity ... source) {
        if (!this.loadedShardsfullyGeometricallyEnclosePolygon(polygon)) {
            if (logger.isDebugEnabled()) {
                logger.debug("{}: Triggering new shard load for {}{}", new Object[]{this.getName(), source.length > 0 ? "Atlas " + new StringList(Iterables.stream(Iterables.asList(source)).map(item -> (Object)((Object)item.getType()) + " " + item.getIdentifier())).join(", ") + " with shape " : "", polygon.toWkt()});
            }
            this.addNewShards(this.sharding.shards(polygon));
        }
    }

    private void newPolyLine(PolyLine polyLine, LineItem ... source) {
        if (!this.loadedShardsfullyGeometricallyEnclosePolyLine(polyLine)) {
            if (logger.isDebugEnabled()) {
                logger.debug("{}: Triggering new shard load for {}{}", new Object[]{this.getName(), source.length > 0 ? "Atlas " + new StringList(Iterables.stream(Iterables.asList(source)).map(item -> (Object)((Object)item.getType()) + " " + item.getIdentifier())).join(", ") + " with shape " : "", polyLine.toWkt()});
            }
            this.addNewShards(this.sharding.shardsIntersecting(polyLine));
        }
    }

    private DynamicRelation newRelation(Relation relation) {
        return new DynamicRelation(this, relation.getIdentifier());
    }

    private Set<Shard> nonNullShards() {
        return new HashSet<Shard>(this.loadedShards.keySet().stream().filter(shard -> this.loadedShards.get(shard) != null).collect(Collectors.toSet()));
    }

    private boolean relationCovered(Relation relation) {
        HashSet<Long> parentRelationIdentifierTree = new HashSet<Long>();
        parentRelationIdentifierTree.add(relation.getIdentifier());
        return this.relationCoveredInternal(relation, parentRelationIdentifierTree);
    }

    private boolean relationCoveredInternal(Relation relation, Set<Long> parentRelationIdentifierTree) {
        RelationMemberList knownMembers = relation.members();
        boolean result = true;
        boolean loop = false;
        for (RelationMember member : knownMembers) {
            AtlasEntity entity = member.getEntity();
            if (entity instanceof Area) {
                if (this.areaCovered((Area)entity)) continue;
                result = false;
                continue;
            }
            if (entity instanceof LineItem) {
                if (this.lineItemCovered((LineItem)entity)) continue;
                result = false;
                continue;
            }
            if (entity instanceof LocationItem) {
                if (this.locationItemCovered((LocationItem)entity)) continue;
                result = false;
                continue;
            }
            if (entity instanceof Relation) {
                long newIdentifier = entity.getIdentifier();
                if (parentRelationIdentifierTree.contains(newIdentifier)) {
                    logger.error("Skipping! Unable to expand on relation which has a loop: {}. Parent tree: {}", (Object)relation, parentRelationIdentifierTree);
                    loop = true;
                    result = true;
                    continue;
                }
                HashSet<Long> newParentRelationIdentifierTree = new HashSet<Long>();
                newParentRelationIdentifierTree.addAll(parentRelationIdentifierTree);
                newParentRelationIdentifierTree.add(newIdentifier);
                if (this.relationCoveredInternal((Relation)entity, newParentRelationIdentifierTree)) continue;
                result = false;
                continue;
            }
            throw new CoreException("Unknown Relation Member Type: {}", entity.getClass().getName());
        }
        if (this.policy.isAggressivelyExploreRelations() && !loop) {
            HashSet onlyNeighboringShards = new HashSet();
            this.loadedShards.keySet().forEach(shard -> this.sharding.neighbors((Shard)shard).forEach(onlyNeighboringShards::add));
            onlyNeighboringShards.removeAll(this.loadedShards.keySet());
            HashSet neighboringShardsContainingRelation = new HashSet();
            onlyNeighboringShards.forEach(shard -> this.policy.getAtlasFetcher().apply((Shard)shard).ifPresent(atlas -> {
                Relation newRelation = atlas.relation(relation.getIdentifier());
                if (newRelation != null) {
                    RelationMemberList newMembers = newRelation.members();
                    for (RelationMember newMember : newMembers) {
                        if (knownMembers.contains(newMember)) continue;
                        neighboringShardsContainingRelation.add(shard);
                        if (!logger.isDebugEnabled()) break;
                        logger.debug("{}: Triggering new shard load for {}{}", new Object[]{this.getName(), "Atlas " + (Object)((Object)relation.getType()) + " containing ", newMember});
                        break;
                    }
                }
            }));
            if (!neighboringShardsContainingRelation.isEmpty()) {
                result = false;
                this.addNewShards(neighboringShardsContainingRelation);
            }
        }
        return result;
    }
}

