/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.geography.atlas.command.buildings;

import com.google.common.collect.ComparisonChain;
import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Objects;
import java.util.Optional;
import java.util.TreeSet;
import java.util.function.Consumer;
import java.util.stream.StreamSupport;
import org.apache.commons.compress.utils.IOUtils;
import org.openstreetmap.atlas.exception.CoreException;
import org.openstreetmap.atlas.geography.Location;
import org.openstreetmap.atlas.geography.MultiPolygon;
import org.openstreetmap.atlas.geography.atlas.Atlas;
import org.openstreetmap.atlas.geography.atlas.command.AbstractAtlasSubCommand;
import org.openstreetmap.atlas.geography.atlas.items.ItemType;
import org.openstreetmap.atlas.geography.atlas.items.complex.buildings.ComplexBuilding;
import org.openstreetmap.atlas.geography.atlas.items.complex.buildings.ComplexBuildingFinder;
import org.openstreetmap.atlas.tags.ISOCountryTag;
import org.openstreetmap.atlas.tags.Taggable;
import org.openstreetmap.atlas.utilities.runtime.Command;
import org.openstreetmap.atlas.utilities.runtime.CommandMap;

public class BuildingsWithHeightSearchSubCommand
extends AbstractAtlasSubCommand {
    private static final Command.Switch<Path> OUTPUT_FILE_PARAMETER = new Command.Switch("output", "HTML file containing information about each 3D building", x$0 -> Paths.get(x$0, new String[0]), Command.Optionality.REQUIRED);
    private BuildingsWithHeightLogger counter;

    public BuildingsWithHeightSearchSubCommand() {
        super("3d-buildings", "Lists all of the buildings that have a height value");
    }

    @Override
    public Command.SwitchList switches() {
        return super.switches().with(OUTPUT_FILE_PARAMETER);
    }

    @Override
    public void usage(PrintStream writer) {
        writer.printf("-input=/path/to/atlas/files : the atlas files we want to load\n", new Object[0]);
        writer.printf("-output=/path/to/output/file\n", new Object[0]);
    }

    @Override
    protected int finish(CommandMap command) {
        try {
            this.counter.close();
        }
        catch (IOException oops) {
            throw new CoreException("Failure to close", oops);
        }
        return 0;
    }

    @Override
    protected void handle(Atlas atlas, CommandMap command) {
        StreamSupport.stream(new ComplexBuildingFinder().find(atlas).spliterator(), false).map(ComplexBuilding.class::cast).filter(this::hasHeight).forEach(this.counter);
    }

    @Override
    protected void start(CommandMap command) {
        super.start(command);
        this.counter = new BuildingsWithHeightLogger(this.createStream(command));
    }

    private PrintStream createStream(CommandMap command) {
        try {
            Path output = (Path)command.get(OUTPUT_FILE_PARAMETER);
            try {
                Files.createDirectories(output.getParent(), new FileAttribute[0]);
            }
            catch (IOException oops) {
                throw new CoreException("Error when creating output directory", oops);
            }
            return new PrintStream(new BufferedOutputStream(new FileOutputStream(output.toFile())));
        }
        catch (IOException oops) {
            throw new CoreException("Failure to open output", oops);
        }
    }

    private boolean hasHeight(ComplexBuilding building) {
        return building.topHeight().isPresent();
    }

    private static final class BuildingsWithHeightLogger
    implements Consumer<ComplexBuilding>,
    Closeable {
        private final PrintStream output;
        private final TreeSet<BuildingHeightItem> items;

        private BuildingsWithHeightLogger(PrintStream output) {
            this.output = output;
            output.printf("<html><head><style>table { font-family: Menlo; }</style></head><body><table>\n", new Object[0]);
            this.items = new TreeSet();
        }

        @Override
        public void accept(ComplexBuilding buildingsWithHeight) {
            BuildingHeightItem item = new BuildingHeightItem(buildingsWithHeight);
            if (item.isValid()) {
                this.items.add(item);
            }
        }

        @Override
        public void close() throws IOException {
            int[] counter = new int[]{0};
            this.items.stream().forEach(item -> {
                counter[0] = counter[0] + 1;
                ((BuildingHeightItem)item).output(counter[0], this.output);
            });
            this.output.printf("</table></body></html>\n", new Object[0]);
            IOUtils.closeQuietly(this.output);
        }
    }

    private static final class BuildingHeightItem
    implements Comparable<BuildingHeightItem> {
        private final String iso3;
        private double height;
        private final long osmIdentifier;
        private final long atlasIdentifier;
        private final String latitude;
        private final String longitude;
        private final String url;
        private final boolean valid;

        BuildingHeightItem(ComplexBuilding building) {
            this.url = String.format("http://www.openstreetmap.org/%s/%d", building.getSource().getType() == ItemType.AREA ? "way" : "relation", building.getOsmIdentifier());
            MultiPolygon outline = building.getOutline();
            boolean bl = this.valid = outline != null;
            if (this.valid) {
                Location location = building.getOutline().outers().iterator().next().first();
                this.iso3 = building.getTag(ISOCountryTag.class, Optional.empty(), new Taggable.TagSearchOption[0]).orElse("UNK");
                this.atlasIdentifier = building.getIdentifier();
                this.osmIdentifier = building.getOsmIdentifier();
                building.topHeight().ifPresent(height -> {
                    this.height = height.asMeters();
                });
                this.latitude = location.getLatitude().toString();
                this.longitude = location.getLongitude().toString();
            } else {
                this.iso3 = null;
                this.atlasIdentifier = -1L;
                this.osmIdentifier = -1L;
                this.latitude = null;
                this.longitude = null;
            }
        }

        @Override
        public int compareTo(BuildingHeightItem otherBuilding) {
            return ComparisonChain.start().compare((Comparable<?>)((Object)this.iso3), (Comparable<?>)((Object)otherBuilding.iso3)).compare(this.height, otherBuilding.height).compare(this.atlasIdentifier, otherBuilding.atlasIdentifier).result();
        }

        public boolean equals(Object otherObject) {
            if (this == otherObject) {
                return true;
            }
            if (otherObject instanceof BuildingHeightItem) {
                BuildingHeightItem otherItem = (BuildingHeightItem)otherObject;
                return this.atlasIdentifier == otherItem.atlasIdentifier;
            }
            return false;
        }

        public int hashCode() {
            return Objects.hash(this.atlasIdentifier);
        }

        private boolean isValid() {
            return this.valid;
        }

        private void output(int count, PrintStream stream) {
            stream.printf("<tr><td>%d</td><td>%s</td><td align=\"right\">%s</td><td align=\"right\">%s</td><td><a href=\"%s\">%s</td><td>%.2f</td><td>%s,%s</td></tr>\n", count, this.iso3, this.atlasIdentifier, this.osmIdentifier, this.url, this.url, this.height, this.latitude, this.longitude);
        }
    }
}

