/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.geography.atlas.command;

import java.io.PrintStream;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.StreamSupport;
import org.openstreetmap.atlas.geography.atlas.Atlas;
import org.openstreetmap.atlas.geography.atlas.command.AbstractAtlasSubCommand;
import org.openstreetmap.atlas.tags.RouteTag;
import org.openstreetmap.atlas.tags.Taggable;
import org.openstreetmap.atlas.tags.annotations.validation.Validators;
import org.openstreetmap.atlas.utilities.runtime.CommandMap;

public class FerrySearchSubCommand
extends AbstractAtlasSubCommand {
    private Set<String> countries;

    public FerrySearchSubCommand() {
        super("ferries", "Searching for ferries");
    }

    @Override
    public void usage(PrintStream writer) {
        writer.printf("-input=/path/to/atlas/files : the atlas files we want to load\n", new Object[0]);
    }

    @Override
    protected int finish(CommandMap command) {
        System.out.println(this.countries);
        return 0;
    }

    @Override
    protected void handle(Atlas atlas, CommandMap command) {
        if (StreamSupport.stream(atlas.entities(i -> i.getIdentifier() > 0L).spliterator(), true).filter(entity -> Validators.isOfType((Taggable)entity, RouteTag.class, (Enum[])new RouteTag[]{RouteTag.FERRY})).findFirst().isPresent()) {
            atlas.metaData().getCountry().ifPresent(this.countries::add);
        }
    }

    @Override
    protected void start(CommandMap command) {
        this.countries = new TreeSet<String>();
    }
}

