/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.geography.atlas.command;

import java.io.PrintStream;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.openstreetmap.atlas.geography.atlas.Atlas;
import org.openstreetmap.atlas.geography.atlas.command.AbstractAtlasSubCommand;
import org.openstreetmap.atlas.geography.atlas.command.AtlasReader;
import org.openstreetmap.atlas.geography.atlas.items.AtlasEntity;
import org.openstreetmap.atlas.geography.atlas.items.AtlasObject;
import org.openstreetmap.atlas.utilities.runtime.Command;
import org.openstreetmap.atlas.utilities.runtime.CommandMap;

public class AtlasFindByAtlasIdentifierSubCommand
extends AbstractAtlasSubCommand {
    private static final Command.Switch<Set<Long>> ATLAS_ID_PARAMETER = new Command.Switch("id", "List of comma-delimited Atlas identifiers", possibleMultipleOSMIdentifier -> Stream.of(possibleMultipleOSMIdentifier.split(",")).map(Long::parseLong).collect(Collectors.toSet()), Command.Optionality.REQUIRED);
    private static final Command.Switch<String> JOINED_OUTPUT_PARAMETER = new Command.Switch("joinedOutput", "The Atlas file to save the joined output to (optional). If not passed the found shards will not be joined and only appear in the console.", String::toString, Command.Optionality.OPTIONAL);
    private final Set<Long> identifiers = new HashSet<Long>();
    private final Set<String> shardNames = new HashSet<String>();

    public AtlasFindByAtlasIdentifierSubCommand() {
        super("find-atlas-id", "Find which atlas files contain particular Atlas features using a given set of Atlas identifiers");
    }

    @Override
    public Command.SwitchList switches() {
        return super.switches().with(ATLAS_ID_PARAMETER, JOINED_OUTPUT_PARAMETER);
    }

    @Override
    public void usage(PrintStream writer) {
        writer.printf("-input=/path/to/atlas/files : the atlas files we want to load\n", new Object[0]);
        writer.printf("-id=1000000,2000000 : comma separated Atlas identifiers to search for\n", new Object[0]);
        writer.printf("-joinedOutput=path/to/joined.atlas : the path to the output Atlas file\n", new Object[0]);
    }

    @Override
    protected void start(CommandMap command) {
        this.identifiers.addAll((Set)command.get(ATLAS_ID_PARAMETER));
    }

    @Override
    protected void handle(Atlas atlas, CommandMap command) {
        atlas.entities(this.identifierCheck()).forEach(item -> {
            System.out.printf(this.formatAtlasObject((AtlasEntity)item), new Object[0]);
            this.shardNames.add(atlas.getName());
        });
    }

    @Override
    protected int finish(CommandMap command) {
        Optional<?> output = command.getOption(JOINED_OUTPUT_PARAMETER);
        if (output.isPresent() && !this.shardNames.isEmpty()) {
            System.out.printf("Stitching shards and saving to output %s\n", output.get());
            AtlasReader.main("join", String.format("-input=%s", command.get((Command.Switch)super.switches().get(0))), String.format("-output=%s", output.get()), String.format("-atlases=%s", String.join((CharSequence)",", this.shardNames)));
        }
        return 0;
    }

    private <T extends AtlasObject> Predicate<T> identifierCheck() {
        return object -> this.identifiers.contains(object.getIdentifier());
    }

    private String formatAtlasObject(AtlasEntity entity) {
        String shardName = entity.getAtlas().metaData().getShardName().orElse("UNKNOWN");
        return String.format("[%s] [%d] [%d] --> [%s:%s] Tags: [%s]\n", new Object[]{entity.getType(), entity.getOsmIdentifier(), entity.getIdentifier(), shardName, entity.getAtlas().getName(), entity.getTags()});
    }
}

