/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.geography.atlas.command;

import java.io.PrintStream;
import java.util.Set;
import java.util.TreeSet;
import org.openstreetmap.atlas.geography.atlas.Atlas;
import org.openstreetmap.atlas.geography.atlas.command.AbstractAtlasSubCommand;
import org.openstreetmap.atlas.utilities.runtime.CommandMap;

public class AtlasCountriesSubCommand
extends AbstractAtlasSubCommand {
    private final Set<String> countries = new TreeSet<String>();

    public AtlasCountriesSubCommand() {
        super("countries", "lists all of the countries found in alphabetical order");
    }

    @Override
    public void usage(PrintStream writer) {
        writer.printf("-input=/path/to/atlas/files : the atlas files we want to load\n", new Object[0]);
    }

    @Override
    protected int finish(CommandMap command) {
        System.out.printf("Countries: %d\n", this.countries.size());
        this.countries.forEach(System.out::println);
        return 0;
    }

    @Override
    protected void handle(Atlas atlas, CommandMap command) {
        atlas.metaData().getCountry().ifPresent(this.countries::add);
    }
}

