/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.geography.atlas;

import com.google.common.collect.Iterables;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.openstreetmap.atlas.exception.CoreException;
import org.openstreetmap.atlas.geography.atlas.Atlas;
import org.openstreetmap.atlas.geography.atlas.AtlasResourceLoader;
import org.openstreetmap.atlas.streaming.resource.File;
import org.openstreetmap.atlas.streaming.resource.Resource;
import org.openstreetmap.atlas.utilities.collections.StringList;
import org.openstreetmap.atlas.utilities.runtime.Command;
import org.openstreetmap.atlas.utilities.runtime.CommandMap;

public abstract class AtlasLoadingCommand
extends Command {
    protected static final Command.Switch<Set<String>> INCLUDE_ONLY_THESE_COUNTRIES_PARAMETER = new Command.Switch("include-only", "list of comma-delimited ISO country codes that we'll include when searching folders for atlas files", possiblyMultipleISOs -> StringList.split(possiblyMultipleISOs, ",").stream().collect(Collectors.toSet()), Command.Optionality.OPTIONAL);
    protected static final Command.Switch<File> INPUT_FOLDER = new Command.Switch("inputFolder", "Path of folder which contains Atlas files", File::new, Command.Optionality.OPTIONAL);
    protected static final Command.Switch<File> INPUT = new Command.Switch("input", "Path of Atlas file", File::new, Command.Optionality.OPTIONAL);
    protected static final Command.Switch<Set<String>> EXCLUDE_THESE_COUNTRIES_PARAMETER = new Command.Switch("exclude", "list of comma-delimited ISO country codes that we'll exclude when searching folders for atlas files", possiblyMultipleISOs -> StringList.split(possiblyMultipleISOs, ",").stream().collect(Collectors.toSet()), Command.Optionality.OPTIONAL);

    protected Atlas loadAtlas(CommandMap commandMap) {
        return this.loadAtlas(INPUT_FOLDER, commandMap);
    }

    protected Atlas loadAtlas(Command.Switch<File> parameter, CommandMap commandMap) {
        AcceptableInputFileFilter filter = new AcceptableInputFileFilter().include((Set)commandMap.get(INCLUDE_ONLY_THESE_COUNTRIES_PARAMETER)).exclude((Set)commandMap.get(EXCLUDE_THESE_COUNTRIES_PARAMETER));
        File input = (File)commandMap.get(INPUT);
        if (input != null) {
            return new AtlasResourceLoader().load(input);
        }
        File inputFolder = (File)commandMap.get(parameter);
        if (inputFolder == null) {
            throw new CoreException("Switch missing: input file or input folder");
        }
        return new AtlasResourceLoader().withResourceFilter(filter).load(inputFolder);
    }

    @Override
    protected Command.SwitchList switches() {
        return new Command.SwitchList().with(INPUT, INPUT_FOLDER, INCLUDE_ONLY_THESE_COUNTRIES_PARAMETER, EXCLUDE_THESE_COUNTRIES_PARAMETER);
    }

    public static class AcceptableInputFileFilter
    implements Predicate<Resource> {
        private static final int START_ISO3_NAME_INDEX = 0;
        private static final int END_ISO3_NAME_INDEX = 3;
        private final Set<String> acceptableISOCodes = new HashSet<String>();
        private final Set<String> excludedISOCodes = new HashSet<String>();

        public AcceptableInputFileFilter exclude(Iterable<String> exclude) {
            if (exclude != null) {
                Iterables.addAll(this.excludedISOCodes, exclude);
            }
            return this;
        }

        public AcceptableInputFileFilter include(Iterable<String> include) {
            if (include != null) {
                Iterables.addAll(this.acceptableISOCodes, include);
            }
            return this;
        }

        @Override
        public boolean test(Resource fileName) {
            String isoCode = fileName.getName().substring(0, 3);
            if (this.acceptableISOCodes.size() > 0 && !this.acceptableISOCodes.contains(isoCode)) {
                return false;
            }
            return this.excludedISOCodes.size() == 0 || !this.excludedISOCodes.contains(isoCode);
        }
    }
}

