/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.geography;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.openstreetmap.atlas.exception.CoreException;
import org.openstreetmap.atlas.geography.Heading;
import org.openstreetmap.atlas.geography.Located;
import org.openstreetmap.atlas.geography.Location;
import org.openstreetmap.atlas.geography.MultiPolygon;
import org.openstreetmap.atlas.geography.Polygon;
import org.openstreetmap.atlas.geography.Rectangle;
import org.openstreetmap.atlas.geography.Segment;
import org.openstreetmap.atlas.geography.Snapper;
import org.openstreetmap.atlas.geography.clipping.Clip;
import org.openstreetmap.atlas.geography.converters.WkbLocationConverter;
import org.openstreetmap.atlas.geography.converters.WkbPolyLineConverter;
import org.openstreetmap.atlas.geography.converters.WktLocationConverter;
import org.openstreetmap.atlas.geography.converters.WktPolyLineConverter;
import org.openstreetmap.atlas.geography.geojson.GeoJsonBuilder;
import org.openstreetmap.atlas.geography.geojson.GeoJsonObject;
import org.openstreetmap.atlas.geography.matching.PolyLineMatch;
import org.openstreetmap.atlas.streaming.resource.WritableResource;
import org.openstreetmap.atlas.streaming.writers.JsonWriter;
import org.openstreetmap.atlas.utilities.collections.Iterables;
import org.openstreetmap.atlas.utilities.collections.MultiIterable;
import org.openstreetmap.atlas.utilities.collections.StringList;
import org.openstreetmap.atlas.utilities.scalars.Angle;
import org.openstreetmap.atlas.utilities.scalars.Distance;
import org.openstreetmap.atlas.utilities.scalars.Ratio;
import org.openstreetmap.atlas.utilities.tuples.Tuple;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PolyLine
implements Collection<Location>,
Located,
Serializable {
    private static final long serialVersionUID = -3291779878869865427L;
    protected static final int SIMPLE_STRING_LENGTH = 200;
    private static final Logger logger = LoggerFactory.getLogger(PolyLine.class);
    private static final String IMMUTABLE_POLYLINE = "A polyline is immutable";
    public static final PolyLine TEST_POLYLINE = new PolyLine(Location.TEST_3, Location.TEST_7, Location.TEST_4, Location.TEST_1, Location.TEST_5);
    public static final String SEPARATOR = ":";
    private final List<Location> points;

    public static GeoJsonObject asGeoJson(Iterable<? extends Iterable<Location>> geometries) {
        return new GeoJsonBuilder().create(Iterables.translate(geometries, geometry -> new GeoJsonBuilder.LocationIterableProperties((Iterable<Location>)geometry, (Map<String, String>)new HashMap<String, String>())));
    }

    public static PolyLine random(int numberPoints, Rectangle bounds) {
        ArrayList locations = new ArrayList();
        IntStream.range(0, numberPoints).forEach((int index) -> locations.add(Location.random(bounds)));
        return new PolyLine(locations);
    }

    public static void saveAsGeoJson(Iterable<? extends Iterable<Location>> geometries, WritableResource resource) {
        try (JsonWriter writer = new JsonWriter(resource);){
            writer.write(PolyLine.asGeoJson(geometries).jsonObject());
        }
    }

    public static PolyLine wkb(byte[] wkb) {
        return new WkbPolyLineConverter().backwardConvert(wkb);
    }

    public static PolyLine wkt(String wkt) {
        return new WktPolyLineConverter().backwardConvert(wkt);
    }

    public PolyLine(Iterable<? extends Location> points) {
        this(Iterables.asList(points));
    }

    public PolyLine(List<? extends Location> points) {
        if (points.isEmpty()) {
            throw new CoreException("Cannot have an empty PolyLine or Polygon.");
        }
        this.points = new ArrayList<Location>(points);
    }

    public PolyLine(Location ... points) {
        this(Iterables.iterable(points));
    }

    @Override
    public boolean add(Location e) {
        throw new IllegalAccessError("Cannot add a Location to a PolyLine.");
    }

    @Override
    public boolean addAll(Collection<? extends Location> collection) {
        throw new IllegalAccessError("Cannot add Locations to a PolyLine.");
    }

    public List<Tuple<Angle, Location>> anglesGreaterThanOrEqualTo(Angle target) {
        ArrayList<Tuple<Angle, Location>> result = new ArrayList<Tuple<Angle, Location>>();
        List<Segment> segments = this.segments();
        if (segments.isEmpty() || segments.size() == 1) {
            return result;
        }
        for (int i = 1; i < segments.size(); ++i) {
            Angle candidate;
            Segment first = segments.get(i - 1);
            Segment second = segments.get(i);
            Optional<Heading> firstHeading = first.heading();
            Optional<Heading> secondHeading = second.heading();
            if (!firstHeading.isPresent() || !secondHeading.isPresent() || !(candidate = firstHeading.get().difference(secondHeading.get())).isGreaterThanOrEqualTo(target)) continue;
            Tuple<Angle, Location> tuple = Tuple.createTuple(candidate, first.end());
            result.add(tuple);
        }
        return result;
    }

    public List<Tuple<Angle, Location>> anglesLessThanOrEqualTo(Angle target) {
        ArrayList<Tuple<Angle, Location>> result = new ArrayList<Tuple<Angle, Location>>();
        List<Segment> segments = this.segments();
        if (segments.isEmpty() || segments.size() == 1) {
            return result;
        }
        for (int i = 1; i < segments.size(); ++i) {
            Angle candidate;
            Segment first = segments.get(i - 1);
            Segment second = segments.get(i);
            Optional<Heading> firstHeading = first.heading();
            Optional<Heading> secondHeading = second.heading();
            if (!firstHeading.isPresent() || !secondHeading.isPresent() || !(candidate = firstHeading.get().difference(secondHeading.get())).isLessThanOrEqualTo(target)) continue;
            Tuple<Angle, Location> tuple = Tuple.createTuple(candidate, first.end());
            result.add(tuple);
        }
        return result;
    }

    public PolyLine append(PolyLine other) {
        if (this.last().equals(other.first())) {
            return new PolyLine(new MultiIterable(this, other.truncate(1, 0)));
        }
        throw new CoreException("Cannot append {} to {} - the end and start points do not match.", other.toWkt(), this.toWkt());
    }

    public GeoJsonObject asGeoJson() {
        ArrayList<PolyLine> geometries = new ArrayList<PolyLine>();
        geometries.add(this);
        return PolyLine.asGeoJson(geometries);
    }

    public Distance averageDistanceTo(PolyLine other) {
        return this.averageOneWayDistanceTo(other).add(other.averageOneWayDistanceTo(this)).scaleBy(Ratio.HALF);
    }

    public Distance averageOneWayDistanceTo(PolyLine other) {
        Distance costDistance = Distance.ZERO;
        for (Location shapePoint : this) {
            costDistance = costDistance.add(shapePoint.snapTo(other).getDistance());
        }
        return costDistance.scaleBy(1.0 / (double)this.size());
    }

    public PolyLine between(Location start, int startOccurrence, Location end, int endOccurrence) {
        ArrayList<Location> result = new ArrayList<Location>();
        boolean started = false;
        int startIndex = 0;
        int endIndex = 0;
        for (Location location : this) {
            if (location.equals(start) && startOccurrence == startIndex++) {
                started = true;
            }
            if (location.equals(end) && endOccurrence == endIndex++) {
                if (!started) {
                    throw new CoreException("Found end first! {}(occurrence {}) and {}(occurrence {}) are not in order with respect to {}", start, startOccurrence, end, endOccurrence, this.toWkt());
                }
                started = false;
                result.add(location);
                break;
            }
            if (!started) continue;
            result.add(location);
        }
        if (started) {
            throw new CoreException("(Start was {}) End {} is not in polyLine {}", start, end, this);
        }
        return new PolyLine((List<? extends Location>)result);
    }

    @Override
    public Rectangle bounds() {
        return Rectangle.forLocations(this);
    }

    @Override
    public void clear() {
        throw new IllegalAccessError(IMMUTABLE_POLYLINE);
    }

    public Clip clip(MultiPolygon clipping, Clip.ClipType clipType) {
        return new Clip(clipType, this, clipping);
    }

    public Clip clip(Polygon clipping, Clip.ClipType clipType) {
        return new Clip(clipType, this, clipping);
    }

    public boolean contains(Location location) {
        for (Location thisLocation : this) {
            if (!thisLocation.equals(location)) continue;
            return true;
        }
        return false;
    }

    @Override
    public final boolean contains(Object object) {
        if (object instanceof Location) {
            return this.contains((Location)object);
        }
        if (object instanceof Segment) {
            return this.contains((Segment)object);
        }
        throw new IllegalAccessError("A polyline can contain a Segment or Location only. Maybe you meant \"covers\"?");
    }

    public boolean contains(Segment segment) {
        List<Segment> segments = this.segments();
        for (Segment thisSegment : segments) {
            if (!thisSegment.equals(segment)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean containsAll(Collection<?> collection) {
        throw new IllegalAccessError();
    }

    public PolyLineMatch costDistanceToOneWay(Iterable<PolyLine> candidates) {
        return new PolyLineMatch(this, Iterables.asList(candidates));
    }

    @Override
    public boolean equals(Object other) {
        if (other instanceof PolyLine) {
            PolyLine that = (PolyLine)other;
            return Iterables.equals(this, that);
        }
        return false;
    }

    public boolean equalsShape(PolyLine other) {
        return this.overlapsShapeOf(other) && other.overlapsShapeOf(this);
    }

    public Optional<Heading> finalHeading() {
        List<Segment> segments = this.segments();
        return segments.size() > 0 ? segments.get(segments.size() - 1).heading() : Optional.empty();
    }

    public Location first() {
        return this.size() > 0 ? this.get(0) : null;
    }

    public Location get(int index) {
        if (index < 0 || index >= this.size()) {
            throw new CoreException("Cannot get a Location with index " + index + ", which is not between 0 and " + this.size());
        }
        return this.points.get(index);
    }

    @Override
    public int hashCode() {
        int result = 0;
        for (Location location : this) {
            result += location.hashCode();
        }
        return result;
    }

    public Optional<Angle> headingDifference() {
        if (this.size() <= 1) {
            return Optional.empty();
        }
        if (this.size() == 2) {
            return Optional.of(Angle.NONE);
        }
        List<Segment> segments = this.segments();
        Segment first = segments.get(0);
        Segment last = segments.get(segments.size() - 1);
        Optional<Heading> heading1 = first.heading();
        if (!heading1.isPresent()) {
            return Optional.empty();
        }
        Optional<Heading> heading2 = last.heading();
        if (!heading2.isPresent()) {
            return Optional.empty();
        }
        return Optional.of(heading2.get().subtract(heading1.get()));
    }

    public Optional<Heading> initialHeading() {
        List<Segment> segments = this.segments();
        return segments.size() > 0 ? segments.get(0).heading() : Optional.empty();
    }

    public Iterable<Location> innerLocations() {
        return this.truncate(1, 1);
    }

    public Set<Location> intersections(PolyLine candidate) {
        HashSet<Location> result = new HashSet<Location>();
        if (this instanceof Segment) {
            result.addAll(candidate.intersections((Segment)this));
        } else {
            List<Segment> segments = this.segments();
            segments.forEach(segment -> {
                Set<Location> intersections = segment.intersections(candidate);
                result.addAll(intersections);
            });
        }
        return result;
    }

    public Set<Location> intersections(Segment candidate) {
        HashSet<Location> result = new HashSet<Location>();
        List<Segment> segments = this.segments();
        segments.forEach(segment -> {
            Location intersection = segment.intersection(candidate);
            if (intersection != null) {
                result.add(intersection);
            }
        });
        return result;
    }

    public boolean intersects(PolyLine other) {
        List<Segment> segments = this.segments();
        List<Segment> otherSegments = other.segments();
        for (Segment segment : segments) {
            for (Segment otherSegment : otherSegments) {
                if (!segment.intersects(otherSegment)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public final boolean isEmpty() {
        return this.points.isEmpty();
    }

    public boolean isPoint() {
        Location firstPoint = null;
        for (Location point : this.points) {
            if (firstPoint == null) {
                firstPoint = point;
                continue;
            }
            if (point.equals(firstPoint)) continue;
            return false;
        }
        return true;
    }

    @Override
    public Iterator<Location> iterator() {
        return this.points.iterator();
    }

    public Location last() {
        return this.points.size() > 0 ? this.get(this.size() - 1) : null;
    }

    public Distance length() {
        Distance result = Distance.ZERO;
        List<Segment> segments = this.segments();
        for (Segment segment : segments) {
            result = result.add(segment.length());
        }
        return result;
    }

    public Angle maximumAngle() {
        List<Segment> segments = this.segments();
        if (segments.isEmpty()) {
            return null;
        }
        if (segments.size() == 1) {
            return Angle.NONE;
        }
        Angle maximum = Angle.NONE;
        for (int i = 1; i < segments.size(); ++i) {
            Angle candidate;
            Segment first = segments.get(i - 1);
            Segment second = segments.get(i);
            Optional<Heading> firstHeading = first.heading();
            Optional<Heading> secondHeading = second.heading();
            if (!firstHeading.isPresent() || !secondHeading.isPresent() || !(candidate = firstHeading.get().difference(secondHeading.get())).isGreaterThan(maximum)) continue;
            maximum = candidate;
        }
        return maximum;
    }

    public Optional<Location> maximumAngleLocation() {
        List<Segment> segments = this.segments();
        if (segments.isEmpty() || segments.size() == 1) {
            return Optional.empty();
        }
        Angle maximum = Angle.NONE;
        Location maximumAngleLocation = null;
        for (int i = 1; i < segments.size(); ++i) {
            Angle candidate;
            Segment first = segments.get(i - 1);
            Segment second = segments.get(i);
            Optional<Heading> firstHeading = first.heading();
            Optional<Heading> secondHeading = second.heading();
            if (!firstHeading.isPresent() || !secondHeading.isPresent() || !(candidate = firstHeading.get().difference(secondHeading.get())).isGreaterThan(maximum) && maximumAngleLocation != null) continue;
            maximum = candidate;
            maximumAngleLocation = first.end();
        }
        return Optional.ofNullable(maximumAngleLocation);
    }

    public Location middle() {
        return this.offsetFromStart(Ratio.HALF);
    }

    public int occurrences(Location node) {
        int result = 0;
        for (Location location : this) {
            if (!location.equals(node)) continue;
            ++result;
        }
        return result;
    }

    public Ratio offsetFromStart(Location node, int occurrenceIndex) {
        Distance max = this.length();
        Distance candidate = Distance.ZERO;
        Location previous = this.first();
        int index = 0;
        for (Location location : this) {
            candidate = candidate.add(previous.distanceTo(location));
            if (location.equals(node) && occurrenceIndex == index++) {
                return Ratio.ratio(candidate.asMeters() / max.asMeters());
            }
            previous = location;
        }
        throw new CoreException("The location {} is not a node of the PolyLine", node);
    }

    public Location offsetFromStart(Ratio ratio) {
        Distance length = this.length();
        Distance stop = length.scaleBy(ratio);
        Distance accumulated = Distance.ZERO;
        List<Segment> segments = this.segments();
        for (Segment segment : segments) {
            if (accumulated.add(segment.length()).isGreaterThan(stop)) {
                Ratio segmentRatio = Ratio.ratio(stop.substract(accumulated).asMeters() / segment.length().asMeters());
                return segment.offsetFromStart(segmentRatio);
            }
            if (accumulated.add(segment.length()).equals(stop)) {
                return segment.end();
            }
            accumulated = accumulated.add(segment.length());
        }
        throw new CoreException("This exception should never be thrown.");
    }

    public Optional<Heading> overallHeading() {
        if (this.isPoint()) {
            logger.warn("Cannot compute a segment's heading when the polyline has zero length : {}", (Object)this);
            return Optional.empty();
        }
        return Optional.ofNullable(this.first().headingTo(this.last()));
    }

    public boolean overlapsShapeOf(PolyLine other) {
        HashSet thisSegments = new HashSet();
        List<Segment> segments = this.segments();
        segments.forEach(segment -> {
            thisSegments.add(segment);
            thisSegments.add(segment.reversed());
        });
        List<Segment> otherSegments = other.segments();
        for (Segment otherSegment : otherSegments) {
            if (thisSegments.contains(otherSegment)) continue;
            return false;
        }
        return true;
    }

    public PolyLine prepend(PolyLine other) {
        if (this.first().equals(other.last())) {
            return new PolyLine(new MultiIterable(other, this.truncate(1, 0)));
        }
        throw new CoreException("Cannot prepend {} to {} - the end and start points do not match.", other.toWkt(), this.toWkt());
    }

    @Override
    public boolean remove(Object object) {
        throw new IllegalAccessError(IMMUTABLE_POLYLINE);
    }

    @Override
    public boolean removeAll(Collection<?> collection) {
        throw new IllegalAccessError(IMMUTABLE_POLYLINE);
    }

    @Override
    public boolean retainAll(Collection<?> collection) {
        throw new IllegalAccessError(IMMUTABLE_POLYLINE);
    }

    public PolyLine reversed() {
        ArrayList<Location> reversed = new ArrayList<Location>();
        for (int i = this.size() - 1; i >= 0; --i) {
            reversed.add(this.get(i));
        }
        return new PolyLine((List<? extends Location>)reversed);
    }

    public void saveAsGeoJson(WritableResource resource) {
        ArrayList<PolyLine> geometries = new ArrayList<PolyLine>();
        geometries.add(this);
        PolyLine.saveAsGeoJson(geometries, resource);
    }

    public List<Segment> segments() {
        ArrayList<Segment> result = new ArrayList<Segment>();
        if (this.size() == 1) {
            result.add(new Segment(this.get(0), this.get(0)));
        } else if (this instanceof Segment) {
            result.add((Segment)this);
        } else {
            Location previous = null;
            for (Location location : this) {
                if (previous == null) {
                    previous = location;
                    continue;
                }
                result.add(new Segment(previous, location));
                previous = location;
            }
        }
        return result;
    }

    public Set<Location> selfIntersections() {
        HashSet<Location> intersections = null;
        boolean isPolygon = this instanceof Polygon;
        List segments = this.segments().stream().filter(segment -> !segment.isPoint()).collect(Collectors.toList());
        for (int i = 0; i < segments.size() - 2; ++i) {
            int limit = isPolygon && i == 0 ? segments.size() - 1 : segments.size();
            for (int j = i + 2; j < limit; ++j) {
                Location intersection = ((Segment)segments.get(i)).intersection((Segment)segments.get(j));
                if (intersection == null) continue;
                if (intersections == null) {
                    intersections = new HashSet<Location>();
                }
                intersections.add(intersection);
            }
        }
        return intersections == null ? Collections.emptySet() : intersections;
    }

    public boolean selfIntersects() {
        boolean isPolygon = this instanceof Polygon;
        List segments = this.segments().stream().filter(segment -> !segment.isPoint()).collect(Collectors.toList());
        for (int i = 0; i < segments.size() - 2; ++i) {
            int limit = isPolygon && i == 0 ? segments.size() - 1 : segments.size();
            for (int j = i + 2; j < limit; ++j) {
                if (((Segment)segments.get(i)).intersection((Segment)segments.get(j)) == null) continue;
                return true;
            }
        }
        return false;
    }

    public Distance shortestDistanceTo(PolyLine other) {
        Distance two;
        Distance one = this.shortestOneWayDistanceTo(other);
        return one.isLessThan(two = other.shortestOneWayDistanceTo(this)) ? one : two;
    }

    public Distance shortestOneWayDistanceTo(PolyLine other) {
        Distance shortest = Distance.MAXIMUM;
        for (Location shapePoint : this) {
            Distance current = shapePoint.snapTo(other).getDistance();
            shortest = current.isLessThan(shortest) ? current : shortest;
        }
        return shortest;
    }

    @Override
    public int size() {
        return this.points.size();
    }

    public Snapper.SnappedLocation snapFrom(Location origin) {
        return new Snapper().snap(origin, this);
    }

    @Override
    public Object[] toArray() {
        return this.points.toArray();
    }

    @Override
    public <T> T[] toArray(T[] array) {
        return this.points.toArray(array);
    }

    public String toCompactString() {
        StringList stringList = new StringList();
        this.forEach(location -> stringList.add(location.toCompactString()));
        return stringList.join(SEPARATOR);
    }

    public String toSimpleString() {
        String string = this.toCompactString();
        if (string.length() > 201) {
            return string.substring(0, 100) + "..." + string.substring(string.length() - 100);
        }
        return string;
    }

    public String toString() {
        return this.toWkt();
    }

    public byte[] toWkb() {
        if (this.size() == 1) {
            return new WkbLocationConverter().convert(this.first());
        }
        return new WkbPolyLineConverter().convert(this);
    }

    public String toWkt() {
        if (this.size() == 1) {
            return new WktLocationConverter().convert(this.first());
        }
        return new WktPolyLineConverter().convert(this);
    }

    public Iterable<Location> truncate(int indexFromStart, int indexFromEnd) {
        if (indexFromStart < 0 || indexFromEnd < 0 || indexFromStart >= this.size() || indexFromEnd >= this.size() || indexFromStart + indexFromEnd >= this.size()) {
            logger.debug("Invalid start index {} or end index {} supplied.", (Object)indexFromStart, (Object)indexFromEnd);
            return Collections.emptyList();
        }
        return Iterables.stream(this).truncate(indexFromStart, indexFromEnd);
    }

    public PolyLine withoutDuplicateConsecutiveShapePoints() {
        ArrayList<Location> shapePoints = new ArrayList<Location>();
        boolean hasDuplicates = false;
        Iterator<Location> locationIterator = this.iterator();
        Location previousLocation = locationIterator.next();
        shapePoints.add(previousLocation);
        while (locationIterator.hasNext()) {
            Location currentLocation = locationIterator.next();
            if (!currentLocation.equals(previousLocation)) {
                shapePoints.add(currentLocation);
            } else {
                hasDuplicates = true;
            }
            previousLocation = currentLocation;
        }
        return hasDuplicates ? new PolyLine((List<? extends Location>)shapePoints) : this;
    }

    protected final List<Location> getPoints() {
        return this.points;
    }
}

