/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.geography;

import org.openstreetmap.atlas.utilities.scalars.Angle;

public class Heading
extends Angle {
    private static final long serialVersionUID = -7621572408790801458L;
    public static final Heading NORTH = Heading.dm7(0L);
    public static final Heading SOUTH = Heading.dm7(1800000000L);
    public static final Heading EAST = Heading.dm7(900000000L);
    public static final Heading WEST = Heading.dm7(2700000000L);
    protected static final int DELTA_DM7 = 1800000000;

    public static Heading degrees(double degrees) {
        return Heading.dm7(Math.round(degrees * 1.0E7));
    }

    public static Heading dm7(long dm7) {
        long rollingDm7 = (dm7 - 1800000000L) % 3600000000L;
        if (rollingDm7 < -1800000000L) {
            rollingDm7 += 3600000000L;
        }
        if (rollingDm7 >= 1800000000L) {
            rollingDm7 -= 3600000000L;
        }
        return new Heading((int)rollingDm7);
    }

    public static Heading radians(double radians) {
        return Heading.dm7(Math.round(radians * 5.72957795E8));
    }

    protected Heading(int dm7) {
        super(dm7);
    }

    @Override
    public long asDm7() {
        return super.asDm7() + 1800000000L;
    }

    @Override
    public String toString() {
        return String.valueOf(this.asDegrees());
    }
}

