/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.generator.world;

import java.util.List;
import java.util.stream.Collectors;
import org.openstreetmap.atlas.generator.AtlasGeneratorHelper;
import org.openstreetmap.atlas.geography.MultiPolygon;
import org.openstreetmap.atlas.geography.atlas.Atlas;
import org.openstreetmap.atlas.geography.atlas.AtlasMetaData;
import org.openstreetmap.atlas.geography.atlas.multi.MultiAtlas;
import org.openstreetmap.atlas.geography.atlas.packed.PackedAtlasCloner;
import org.openstreetmap.atlas.geography.atlas.pbf.AtlasLoadingOption;
import org.openstreetmap.atlas.geography.atlas.pbf.OsmPbfLoader;
import org.openstreetmap.atlas.geography.atlas.statistics.AtlasStatistics;
import org.openstreetmap.atlas.geography.atlas.statistics.Counter;
import org.openstreetmap.atlas.geography.boundary.CountryBoundaryMap;
import org.openstreetmap.atlas.geography.sharding.SlippyTile;
import org.openstreetmap.atlas.streaming.resource.File;
import org.openstreetmap.atlas.streaming.resource.FileSuffix;
import org.openstreetmap.atlas.streaming.resource.Resource;
import org.openstreetmap.atlas.tags.filters.ConfiguredTaggableFilter;
import org.openstreetmap.atlas.utilities.collections.Maps;
import org.openstreetmap.atlas.utilities.conversion.StringConverter;
import org.openstreetmap.atlas.utilities.runtime.Command;
import org.openstreetmap.atlas.utilities.runtime.CommandMap;
import org.openstreetmap.atlas.utilities.time.Time;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WorldAtlasGenerator
extends Command {
    private static final Logger logger = LoggerFactory.getLogger(WorldAtlasGenerator.class);
    private static final Command.Switch<File> PBF = new Command.Switch("pbf", "The pbf file or folder containing the OSM pbfs", File::new, Command.Optionality.REQUIRED);
    private static final Command.Switch<File> ATLAS = new Command.Switch("atlas", "The atlas file to which the Atlas will be saved", File::new, Command.Optionality.REQUIRED);
    private static final Command.Switch<File> STATISTICS = new Command.Switch("statistics", "The file that will contain the statistics", File::new, Command.Optionality.OPTIONAL);
    public static final Command.Switch<CountryBoundaryMap> BOUNDARIES = new Command.Switch("boundaries", "The boundary map to use", value -> CountryBoundaryMap.fromPlainText(new File((String)value)), Command.Optionality.REQUIRED);
    public static final Command.Switch<String> CODE_VERSION = new Command.Switch<String>("codeVersion", "The code version", StringConverter.IDENTITY, Command.Optionality.OPTIONAL, "unknown");
    public static final Command.Switch<String> DATA_VERSION = new Command.Switch<String>("dataVersion", "The data version", StringConverter.IDENTITY, Command.Optionality.OPTIONAL, "unknown");
    public static final Command.Switch<Boolean> USE_RAW_ATLAS = new Command.Switch("useRawAtlas", "Allow PBF to Atlas process to use Raw Atlas flow", Boolean::parseBoolean, Command.Optionality.OPTIONAL, "false");
    public static final Command.Switch<String> SHOULD_ALWAYS_SLICE_CONFIGURATION = new Command.Switch<String>("shouldAlwaysSliceConfiguration", "The path to the configuration file that defines which entities on which country slicing will always be attempted regardless of the number of countries it intersects according to the country boundary map's grid index.", StringConverter.IDENTITY, Command.Optionality.OPTIONAL);

    public static void main(String[] args) {
        new WorldAtlasGenerator().run(args);
    }

    @Override
    protected int onRun(CommandMap command) {
        Atlas atlas;
        CountryBoundaryMap countryBoundaryMap = (CountryBoundaryMap)command.get(BOUNDARIES);
        File pbf = (File)command.get(PBF);
        File output = (File)command.get(ATLAS);
        File statisticsOutput = (File)command.get(STATISTICS);
        String codeVersion = (String)command.get(CODE_VERSION);
        String dataVersion = (String)command.get(DATA_VERSION);
        SlippyTile world = SlippyTile.ROOT;
        String forceSlicingConfiguration = (String)command.get(SHOULD_ALWAYS_SLICE_CONFIGURATION);
        ConfiguredTaggableFilter forceSlicingPredicate = forceSlicingConfiguration == null ? taggable -> false : AtlasGeneratorHelper.getTaggableFilterFrom(new File(forceSlicingConfiguration));
        countryBoundaryMap.setShouldAlwaysSlicePredicate(forceSlicingPredicate);
        Time start = Time.now();
        AtlasLoadingOption loadingOptions = AtlasLoadingOption.createOptionWithAllEnabled(countryBoundaryMap).setAdditionalCountryCodes(countryBoundaryMap.allCountryNames());
        AtlasMetaData metaData = new AtlasMetaData(null, true, codeVersion, dataVersion, "WORLD", world.getName(), Maps.hashMap(new String[0]));
        Counter counter = new Counter();
        counter.setCountsDefinition(Counter.POI_COUNTS_DEFINITION.getDefault());
        if (pbf.isDirectory()) {
            List<Atlas> pieces = pbf.listFilesRecursively().stream().filter(pbfFile -> pbfFile.getName().endsWith(FileSuffix.PBF.toString())).map(pbfFile -> {
                logger.info("Generating pieced atlas from {}", pbfFile);
                OsmPbfLoader loader = new OsmPbfLoader((Resource)pbfFile, MultiPolygon.MAXIMUM, loadingOptions).withMetaData(metaData);
                return loader.read();
            }).filter(piece -> piece != null).collect(Collectors.toList());
            logger.info("Concatenating atlas from {} pieces.", (Object)pieces.size());
            atlas = pieces.isEmpty() ? null : new PackedAtlasCloner().cloneFrom(new MultiAtlas(pieces));
        } else {
            logger.info("Generating world atlas from {}", (Object)pbf);
            OsmPbfLoader loader = new OsmPbfLoader(pbf, MultiPolygon.MAXIMUM, loadingOptions).withMetaData(metaData);
            atlas = loader.read();
        }
        if (atlas == null) {
            logger.warn("There was no data to add to the Atlas.");
            return 0;
        }
        logger.info("Saving world atlas to {}", (Object)output);
        atlas.save(output);
        logger.info("Generating world statistics...");
        AtlasStatistics statistics = counter.processAtlas(atlas);
        logger.info("Saving world statistics to {}", (Object)statisticsOutput);
        statistics.save(statisticsOutput);
        logger.info("Finished creating world atlas in {}", (Object)start.elapsedSince());
        return 0;
    }

    @Override
    protected Command.SwitchList switches() {
        return new Command.SwitchList().with(PBF, ATLAS, STATISTICS, BOUNDARIES, CODE_VERSION, DATA_VERSION, SHOULD_ALWAYS_SLICE_CONFIGURATION);
    }
}

