/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.generator.tools.caching;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.Map;
import java.util.Optional;
import org.openstreetmap.atlas.exception.CoreException;
import org.openstreetmap.atlas.generator.tools.filesystem.FileSystemHelper;
import org.openstreetmap.atlas.geography.sharding.Shard;
import org.openstreetmap.atlas.streaming.resource.FileSuffix;
import org.openstreetmap.atlas.streaming.resource.Resource;
import org.openstreetmap.atlas.utilities.caching.ConcurrentResourceCache;
import org.openstreetmap.atlas.utilities.caching.strategies.SystemTemporaryFileCachingStrategy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HadoopAtlasFileCache
extends ConcurrentResourceCache {
    private static final Logger logger = LoggerFactory.getLogger(HadoopAtlasFileCache.class);
    private final String parentAtlasPath;

    public HadoopAtlasFileCache(String parentAtlasPath, Map<String, String> configuration) {
        super(new SystemTemporaryFileCachingStrategy(), (URI uri) -> FileSystemHelper.resource(uri.toString(), configuration));
        this.parentAtlasPath = parentAtlasPath;
    }

    public Optional<Resource> get(String country, Shard shard) {
        URI atlasURI;
        String atlasName = String.format("%s_%s", country, shard.getName());
        String atlasURIString = this.parentAtlasPath + "/" + country + "/" + atlasName + FileSuffix.ATLAS.toString();
        try {
            atlasURI = new URI(atlasURIString);
        }
        catch (URISyntaxException exception) {
            throw new CoreException("Bad URI syntax: {}", atlasURIString, exception);
        }
        return this.get(atlasURI);
    }
}

