/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.generator.persistence;

import org.apache.hadoop.mapred.lib.MultipleOutputFormat;
import org.openstreetmap.atlas.generator.persistence.scheme.SlippyTilePersistenceScheme;
import org.openstreetmap.atlas.geography.sharding.SlippyTile;
import org.openstreetmap.atlas.geography.sharding.converters.SlippyTileConverter;
import org.openstreetmap.atlas.utilities.collections.StringList;

public abstract class AbstractMultipleAtlasBasedOutputFormat<Type>
extends MultipleOutputFormat<String, Type> {
    public static final String DEFAULT_SCHEME = "";

    protected String generateFileNameForKeyValue(String key, Type value, String name) {
        StringList countrySplit = StringList.split(key, "_");
        String country = countrySplit.get(0);
        String shard = countrySplit.get(1);
        String schemeDefinition = countrySplit.size() > 2 ? countrySplit.get(2) : DEFAULT_SCHEME;
        SlippyTilePersistenceScheme scheme = new SlippyTilePersistenceScheme(schemeDefinition);
        SlippyTile slippyTile = new SlippyTileConverter().backwardConvert(shard);
        return country + "/" + scheme.compile(slippyTile) + country + "_" + shard;
    }
}

