/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.generator.creator;

import java.io.Serializable;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Optional;
import java.util.function.Function;
import org.openstreetmap.atlas.exception.CoreException;
import org.openstreetmap.atlas.generator.PbfLoader;
import org.openstreetmap.atlas.generator.PbfLocator;
import org.openstreetmap.atlas.generator.persistence.scheme.SlippyTilePersistenceScheme;
import org.openstreetmap.atlas.generator.sharding.AtlasSharding;
import org.openstreetmap.atlas.geography.atlas.Atlas;
import org.openstreetmap.atlas.geography.atlas.AtlasResourceLoader;
import org.openstreetmap.atlas.geography.atlas.packed.PackedAtlas;
import org.openstreetmap.atlas.geography.atlas.pbf.AtlasLoadingOption;
import org.openstreetmap.atlas.geography.atlas.raw.creation.RawAtlasGenerator;
import org.openstreetmap.atlas.geography.atlas.raw.sectioning.WaySectionProcessor;
import org.openstreetmap.atlas.geography.atlas.raw.slicing.RawAtlasCountrySlicer;
import org.openstreetmap.atlas.geography.boundary.CountryBoundaryMap;
import org.openstreetmap.atlas.geography.sharding.Shard;
import org.openstreetmap.atlas.geography.sharding.Sharding;
import org.openstreetmap.atlas.geography.sharding.SlippyTile;
import org.openstreetmap.atlas.streaming.resource.File;
import org.openstreetmap.atlas.streaming.resource.FileSuffix;
import org.openstreetmap.atlas.utilities.collections.Maps;
import org.openstreetmap.atlas.utilities.conversion.StringConverter;
import org.openstreetmap.atlas.utilities.runtime.Command;
import org.openstreetmap.atlas.utilities.runtime.CommandMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RawAtlasCreator
extends Command {
    private static final Logger logger = LoggerFactory.getLogger(RawAtlasCreator.class);
    private static final String DEFAULT_CACHE_NAME = "__RawAtlasCreator_slicedAtlasCache__";
    public static final Command.Switch<CountryBoundaryMap> BOUNDARIES = new Command.Switch("boundaries", "The boundary map to use", value -> CountryBoundaryMap.fromPlainText(new File((String)value)), Command.Optionality.REQUIRED);
    public static final Command.Switch<String> COUNTRY = new Command.Switch<String>("country", "The country code", StringConverter.IDENTITY, Command.Optionality.REQUIRED);
    public static final Command.Switch<File> OUTPUT = new Command.Switch("output", "The path where the output will be saved", value -> {
        File result = new File((String)value);
        result.mkdirs();
        return result;
    }, Command.Optionality.REQUIRED);
    public static final Command.Switch<String> PBF_PATH = new Command.Switch<String>("pbfs", "The path to PBF shards needed to build the desired atlas", StringConverter.IDENTITY, Command.Optionality.REQUIRED);
    public static final Command.Switch<String> SLICED_CACHE_PATH = new Command.Switch<String>("slicedCache", "The path to the sliced atlas cache for DynamicAtlas", StringConverter.IDENTITY, Command.Optionality.OPTIONAL, System.getProperty("user.home") + "/" + "__RawAtlasCreator_slicedAtlasCache__");
    public static final Command.Switch<Boolean> FAIL_FAST_CACHE_MISS = new Command.Switch("failFastOnSlicedCacheMiss", "Fail fast on a sliced cache miss", Boolean::parseBoolean, Command.Optionality.OPTIONAL, "true");
    public static final Command.Switch<String> PBF_SHARDING = new Command.Switch<String>("pbfSharding", "The sharding tree of the pbf files. If not specified, this will default to the general Atlas sharding.", StringConverter.IDENTITY, Command.Optionality.OPTIONAL);
    public static final Command.Switch<String> SHARDING_TYPE = new Command.Switch<String>("sharding", "The sharding definition.", StringConverter.IDENTITY, Command.Optionality.REQUIRED);
    public static final Command.Switch<Shard> TILE = new Command.Switch("tile", "The SlippyTile name to use", SlippyTile::forName, Command.Optionality.REQUIRED);
    public static final Command.Switch<RawAtlasFlavor> ATLAS_FLAVOR = new Command.Switch("rawAtlasFlavor", "Which flavor of raw atlas - " + RawAtlasFlavor.RawAtlas.toString() + ", " + RawAtlasFlavor.SlicedRawAtlas.toString() + ", or " + RawAtlasFlavor.SectionedRawAtlas.toString(), RawAtlasFlavor::flavorStringToRawAtlasFlavor, Command.Optionality.OPTIONAL, RawAtlasFlavor.SectionedRawAtlas.toString());
    public static final Command.Switch<Boolean> USE_JAVA_ATLAS = new Command.Switch("useJavaAtlas", "Use the Java serialization format.", Boolean::parseBoolean, Command.Optionality.OPTIONAL, "false");

    public static void main(String[] args) {
        new RawAtlasCreator().run(args);
    }

    @Override
    protected int onRun(CommandMap command) {
        CountryBoundaryMap countryBoundaryMap = (CountryBoundaryMap)command.get(BOUNDARIES);
        Shard shardToBuild = (Shard)command.get(TILE);
        String pbfPath = (String)command.get(PBF_PATH);
        String slicedCachePath = (String)command.get(SLICED_CACHE_PATH);
        boolean failFastOnSlicedCacheMiss = (Boolean)command.get(FAIL_FAST_CACHE_MISS);
        SlippyTilePersistenceScheme pbfScheme = new SlippyTilePersistenceScheme(PbfLocator.DEFAULT_SCHEME);
        String pbfShardingName = (String)command.get(PBF_SHARDING);
        String shardingName = (String)command.get(SHARDING_TYPE);
        Sharding sharding = AtlasSharding.forString(shardingName, Maps.stringMap(new String[0]));
        Sharding pbfSharding = pbfShardingName != null ? AtlasSharding.forString(shardingName, Maps.stringMap(new String[0])) : sharding;
        String countryName = (String)command.get(COUNTRY);
        File output = (File)command.get(OUTPUT);
        RawAtlasFlavor atlasFlavor = (RawAtlasFlavor)((Object)command.get(ATLAS_FLAVOR));
        boolean useJavaFormat = (Boolean)command.get(USE_JAVA_ATLAS);
        PbfLoader.setAtlasSaveFolder(output);
        PackedAtlas atlas = this.runGenerationForFlavor(atlasFlavor, countryBoundaryMap, shardToBuild, pbfPath, slicedCachePath, failFastOnSlicedCacheMiss, pbfScheme, pbfSharding, sharding, countryName);
        if (useJavaFormat) {
            atlas.setSaveSerializationFormat(PackedAtlas.AtlasSerializationFormat.JAVA);
        } else {
            atlas.setSaveSerializationFormat(PackedAtlas.AtlasSerializationFormat.PROTOBUF);
        }
        atlas.save(output.child(countryName + "_" + shardToBuild.getName() + (Object)((Object)FileSuffix.ATLAS)));
        atlas.saveAsGeoJson(output.child(countryName + "_" + shardToBuild.getName() + (Object)((Object)FileSuffix.GEO_JSON)));
        return 0;
    }

    @Override
    protected Command.SwitchList switches() {
        return new Command.SwitchList().with(BOUNDARIES, TILE, SHARDING_TYPE, PBF_PATH, SLICED_CACHE_PATH, FAIL_FAST_CACHE_MISS, PBF_SHARDING, COUNTRY, OUTPUT, ATLAS_FLAVOR, USE_JAVA_ATLAS);
    }

    private Function<Shard, Optional<Atlas>> atlasFetcher(String countryName, String slicedCachePath, boolean failFastOnSlicedCacheMiss, String pbfPath, CountryBoundaryMap countryBoundaryMap) {
        return (Function<Shard, Optional> & Serializable)shard -> {
            String shardName = shard.getName();
            String atlasName = countryName + "_" + shardName + (Object)((Object)FileSuffix.ATLAS);
            AtlasResourceLoader loader = new AtlasResourceLoader();
            Path slicedCacheFile = Paths.get(slicedCachePath, atlasName);
            RawAtlasCreator creator = new RawAtlasCreator();
            Optional<Atlas> atlasOption = Optional.ofNullable(loader.load(new File(slicedCacheFile.toString())));
            if (!atlasOption.isPresent()) {
                logger.warn("Sliced cache miss for {}, generating...", (Object)atlasName);
                try {
                    atlasOption = Optional.ofNullable(creator.generateSlicedAtlasFromScratch(pbfPath, countryName, countryBoundaryMap, (Shard)shard));
                }
                catch (Exception exception) {
                    logger.error("{}", (Object)exception.toString());
                    atlasOption = Optional.empty();
                }
                if (atlasOption.isPresent()) {
                    File atlasFile = new File(slicedCacheFile.toString());
                    atlasOption.get().save(atlasFile);
                    logger.info("Successfully saved {} to sliced cache", (Object)atlasName);
                    return atlasOption;
                } else {
                    logger.error("Failed to generate sliced atlas {}", (Object)atlasName);
                    if (!failFastOnSlicedCacheMiss) throw new CoreException("Failed to generate sliced atlas {}", atlasName);
                    logger.error("Failing fast, it is likely the PBF was missing");
                    System.exit(1);
                }
                return atlasOption;
            }
            logger.info("Sliced cache hit for {}", (Object)atlasName);
            return atlasOption;
        };
    }

    private Atlas generateRawAtlas(String pbfPath, Shard shardToBuild) {
        RawAtlasGenerator rawAtlasGenerator = new RawAtlasGenerator(new File(this.getPBFFilePathFromDirectory(pbfPath, shardToBuild)));
        Atlas rawAtlas = rawAtlasGenerator.build();
        return rawAtlas;
    }

    private Atlas generateSectionedAtlasGivenSlicedAtlas(String countryName, Shard shardToBuild, CountryBoundaryMap countryBoundaryMap, Sharding sharding, String slicedCachePath, boolean failFastOnSlicedCacheMiss, String pbfPath) {
        Function<Shard, Optional<Atlas>> slicedRawAtlasFetcher = this.atlasFetcher(countryName, slicedCachePath, failFastOnSlicedCacheMiss, pbfPath, countryBoundaryMap);
        WaySectionProcessor processor = new WaySectionProcessor(shardToBuild, AtlasLoadingOption.createOptionWithAllEnabled(countryBoundaryMap), sharding, slicedRawAtlasFetcher);
        Atlas finalAtlas = processor.run();
        return finalAtlas;
    }

    private Atlas generateSlicedAtlasFromScratch(String pbfPath, String countryName, CountryBoundaryMap countryBoundaryMap, Shard shardToBuild) {
        return new RawAtlasCountrySlicer(countryName, countryBoundaryMap).slice(new RawAtlasGenerator(new File(this.getPBFFilePathFromDirectory(pbfPath, shardToBuild))).build());
    }

    private Atlas generateSlicedAtlasGivenRawAtlas(String countryName, CountryBoundaryMap countryBoundaryMap, Atlas rawAtlas) {
        Atlas slicedRawAtlas = new RawAtlasCountrySlicer(countryName, countryBoundaryMap).slice(rawAtlas);
        return slicedRawAtlas;
    }

    private String getPBFFilePathFromDirectory(String pbfPath, Shard shardToBuild) {
        Path pbfPathWithFile = Paths.get(pbfPath, shardToBuild.getName() + (Object)((Object)FileSuffix.PBF));
        return pbfPathWithFile.toString();
    }

    private PackedAtlas runGenerationForFlavor(RawAtlasFlavor atlasFlavor, CountryBoundaryMap countryBoundaryMap, Shard shardToBuild, String pbfPath, String slicedCachePath, boolean failFastOnSlicedCacheMiss, SlippyTilePersistenceScheme pbfScheme, Sharding pbfSharding, Sharding sharding, String countryName) {
        logger.info("Using raw atlas flavor {}", (Object)atlasFlavor);
        Atlas rawAtlas = this.generateRawAtlas(pbfPath, shardToBuild);
        if (atlasFlavor == RawAtlasFlavor.RawAtlas) {
            return (PackedAtlas)rawAtlas;
        }
        Atlas slicedAtlas = this.generateSlicedAtlasGivenRawAtlas(countryName, countryBoundaryMap, rawAtlas);
        if (atlasFlavor == RawAtlasFlavor.SlicedRawAtlas) {
            return (PackedAtlas)slicedAtlas;
        }
        Atlas sectionedAtlas = this.generateSectionedAtlasGivenSlicedAtlas(countryName, shardToBuild, countryBoundaryMap, sharding, slicedCachePath, failFastOnSlicedCacheMiss, pbfPath);
        if (atlasFlavor == RawAtlasFlavor.SectionedRawAtlas) {
            return (PackedAtlas)sectionedAtlas;
        }
        throw new CoreException("RawAtlasFlavor value {} was invalid!", atlasFlavor.toString());
    }

    private static enum RawAtlasFlavor {
        RawAtlas("raw"),
        SlicedRawAtlas("sliced"),
        SectionedRawAtlas("sectioned");

        private final String flavorString;

        public static RawAtlasFlavor flavorStringToRawAtlasFlavor(String string) {
            for (RawAtlasFlavor flavor : RawAtlasFlavor.values()) {
                if (!flavor.toString().equalsIgnoreCase(string)) continue;
                return flavor;
            }
            throw new CoreException("Invalid RawAtlasFlavor {}", string);
        }

        private RawAtlasFlavor(String flavorString) {
            this.flavorString = flavorString;
        }

        public String toString() {
            return this.flavorString;
        }
    }
}

