/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.generator;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import org.apache.spark.api.java.function.PairFlatMapFunction;
import org.apache.spark.api.java.function.PairFunction;
import org.openstreetmap.atlas.exception.CoreException;
import org.openstreetmap.atlas.generator.AtlasGenerationTask;
import org.openstreetmap.atlas.generator.AtlasGenerator;
import org.openstreetmap.atlas.generator.AtlasLocator;
import org.openstreetmap.atlas.generator.PbfContext;
import org.openstreetmap.atlas.generator.PbfLoader;
import org.openstreetmap.atlas.generator.persistence.scheme.SlippyTilePersistenceScheme;
import org.openstreetmap.atlas.generator.tools.caching.HadoopAtlasFileCache;
import org.openstreetmap.atlas.geography.atlas.Atlas;
import org.openstreetmap.atlas.geography.atlas.AtlasResourceLoader;
import org.openstreetmap.atlas.geography.atlas.delta.AtlasDelta;
import org.openstreetmap.atlas.geography.atlas.pbf.AtlasLoadingOption;
import org.openstreetmap.atlas.geography.atlas.raw.sectioning.WaySectionProcessor;
import org.openstreetmap.atlas.geography.atlas.raw.slicing.RawAtlasCountrySlicer;
import org.openstreetmap.atlas.geography.atlas.statistics.AtlasStatistics;
import org.openstreetmap.atlas.geography.atlas.statistics.Counter;
import org.openstreetmap.atlas.geography.boundary.CountryBoundaryMap;
import org.openstreetmap.atlas.geography.sharding.CountryShard;
import org.openstreetmap.atlas.geography.sharding.Shard;
import org.openstreetmap.atlas.geography.sharding.Sharding;
import org.openstreetmap.atlas.streaming.resource.Resource;
import org.openstreetmap.atlas.streaming.resource.StringResource;
import org.openstreetmap.atlas.tags.filters.ConfiguredTaggableFilter;
import org.openstreetmap.atlas.utilities.collections.StringList;
import org.openstreetmap.atlas.utilities.configuration.StandardConfiguration;
import org.openstreetmap.atlas.utilities.runtime.system.memory.Memory;
import org.openstreetmap.atlas.utilities.time.Time;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Tuple2;

public final class AtlasGeneratorHelper
implements Serializable {
    private static final long serialVersionUID = 1300098384789754747L;
    private static final Logger logger = LoggerFactory.getLogger(AtlasGeneratorHelper.class);
    private static final AtlasResourceLoader ATLAS_LOADER = new AtlasResourceLoader();

    public static StandardConfiguration getStandardConfigurationFrom(Resource configurationResource) {
        return new StandardConfiguration(configurationResource);
    }

    public static ConfiguredTaggableFilter getTaggableFilterFrom(Resource configurationResource) {
        return new ConfiguredTaggableFilter(AtlasGeneratorHelper.getStandardConfigurationFrom(configurationResource));
    }

    protected static Function<Shard, Optional<Atlas>> atlasFetcher(HadoopAtlasFileCache atlasCache, String country, Set<Shard> validShards) {
        return (Function<Shard, Optional> & Serializable)shard -> {
            if (!validShards.isEmpty() && !validShards.contains(shard)) {
                logger.debug("Ignoring loading request for invalid shard {}", shard);
                return Optional.empty();
            }
            Optional<Resource> cachedAtlasResource = atlasCache.get(country, (Shard)shard);
            if (cachedAtlasResource.isPresent()) {
                logger.debug("Cache hit, returning loaded atlas for shard {}", shard);
                return Optional.ofNullable(ATLAS_LOADER.load(cachedAtlasResource.get()));
            }
            logger.debug("No atlas file found for shard {}", shard);
            return Optional.empty();
        };
    }

    protected static AtlasLoadingOption buildAtlasLoadingOption(CountryBoundaryMap boundaries, Map<String, String> sparkContext, Map<String, String> properties) {
        String pbfRelationConfiguration;
        String pbfWayConfiguration;
        String pbfNodeConfiguration;
        String waySectioningConfiguration;
        AtlasLoadingOption atlasLoadingOption = AtlasLoadingOption.createOptionWithAllEnabled(boundaries);
        String edgeConfiguration = properties.get(AtlasGenerator.EDGE_CONFIGURATION.getName());
        if (edgeConfiguration != null) {
            atlasLoadingOption.setEdgeFilter(AtlasGeneratorHelper.getTaggableFilterFrom(new StringResource(edgeConfiguration)));
        }
        if ((waySectioningConfiguration = properties.get(AtlasGenerator.WAY_SECTIONING_CONFIGURATION.getName())) != null) {
            atlasLoadingOption.setWaySectionFilter(AtlasGeneratorHelper.getTaggableFilterFrom(new StringResource(waySectioningConfiguration)));
        }
        if ((pbfNodeConfiguration = properties.get(AtlasGenerator.PBF_NODE_CONFIGURATION.getName())) != null) {
            atlasLoadingOption.setOsmPbfNodeFilter(AtlasGeneratorHelper.getTaggableFilterFrom(new StringResource(pbfNodeConfiguration)));
        }
        if ((pbfWayConfiguration = properties.get(AtlasGenerator.PBF_WAY_CONFIGURATION.getName())) != null) {
            atlasLoadingOption.setOsmPbfWayFilter(AtlasGeneratorHelper.getTaggableFilterFrom(new StringResource(pbfWayConfiguration)));
        }
        if ((pbfRelationConfiguration = properties.get(AtlasGenerator.PBF_RELATION_CONFIGURATION.getName())) != null) {
            atlasLoadingOption.setOsmPbfRelationFilter(AtlasGeneratorHelper.getTaggableFilterFrom(new StringResource(pbfRelationConfiguration)));
        }
        return atlasLoadingOption;
    }

    protected static PairFlatMapFunction<Tuple2<String, Atlas>, String, AtlasDelta> computeAtlasDelta(Map<String, String> sparkContext, String previousOutputForDelta) {
        return (PairFlatMapFunction & Serializable)tuple -> {
            String countryShardName = (String)tuple._1();
            Atlas current = (Atlas)tuple._2();
            logger.info("Starting computing deltas for Atlas {}", (Object)current.getName());
            Time start = Time.now();
            ArrayList<Tuple2> result = new ArrayList<Tuple2>();
            try {
                Optional<Atlas> alter = new AtlasLocator(sparkContext).atlasForShard(previousOutputForDelta + "/" + StringList.split(countryShardName, "_").get(0), countryShardName);
                if (alter.isPresent()) {
                    logger.info("Printing memory after other Atlas loaded for Delta {}", (Object)current.getName());
                    Memory.printCurrentMemory();
                    AtlasDelta delta = new AtlasDelta(current, alter.get()).generate();
                    result.add(new Tuple2((Object)countryShardName, (Object)delta));
                }
            }
            catch (Exception e) {
                logger.error("Skipping! Could not generate deltas for {}", (Object)current.getName(), (Object)e);
            }
            logger.info("Finished computing deltas for Atlas {} in {}", (Object)current.getName(), (Object)start.elapsedSince());
            return result;
        };
    }

    protected static PairFunction<Tuple2<String, Atlas>, String, AtlasStatistics> generateAtlasStatistics(Sharding sharding) {
        return (PairFunction & Serializable)tuple -> {
            String shardName = (String)tuple._1();
            logger.info("Starting generating Atlas statistics for {}", (Object)shardName);
            Time start = Time.now();
            Counter counter = new Counter().withSharding(sharding);
            counter.setCountsDefinition(Counter.POI_COUNTS_DEFINITION.getDefault());
            AtlasStatistics statistics = new AtlasStatistics();
            try {
                statistics = counter.processAtlas((Atlas)tuple._2());
                logger.info("Finished generating Atlas statistics for {} in {}", (Object)shardName, (Object)start.elapsedSince());
            }
            catch (Exception e) {
                logger.error("Building Atlas Statistics for {} failed!", (Object)shardName, (Object)e);
            }
            return new Tuple2((Object)shardName, (Object)statistics);
        };
    }

    protected static PairFunction<AtlasGenerationTask, String, Atlas> generateRawAtlas(CountryBoundaryMap boundaries, Map<String, String> sparkContext, Map<String, String> loadingOptions, PbfContext pbfContext, SlippyTilePersistenceScheme atlasScheme) {
        return (PairFunction & Serializable)task -> {
            Atlas atlas;
            String countryName = task.getCountry();
            Shard shard = task.getShard();
            String name = countryName + "_" + shard.getName();
            logger.info("Starting creating raw Atlas {}", (Object)name);
            Time start = Time.now();
            AtlasLoadingOption atlasLoadingOption = AtlasGeneratorHelper.buildAtlasLoadingOption(boundaries, sparkContext, loadingOptions);
            atlasLoadingOption.setAdditionalCountryCodes(countryName);
            PbfLoader loader = new PbfLoader(pbfContext, sparkContext, boundaries, atlasLoadingOption, (String)loadingOptions.get(AtlasGenerator.CODE_VERSION.getName()), (String)loadingOptions.get(AtlasGenerator.DATA_VERSION.getName()), task.getAllShards());
            try {
                atlas = loader.generateRawAtlas(countryName, shard);
            }
            catch (Throwable e) {
                throw new CoreException("Building raw Atlas {} failed!", name, e);
            }
            logger.info("Finished creating raw Atlas {} in {}", (Object)name, (Object)start.elapsedSince());
            logger.info("Printing memory after loading raw Atlas {}", (Object)name);
            Memory.printCurrentMemory();
            Tuple2 result = new Tuple2((Object)(name + "_" + atlasScheme.getScheme()), (Object)atlas);
            return result;
        };
    }

    protected static PairFunction<Tuple2<String, Atlas>, String, Atlas> sectionRawAtlas(CountryBoundaryMap boundaries, Sharding sharding, Map<String, String> sparkContext, Map<String, String> loadingOptions, String slicedRawAtlasPath, List<AtlasGenerationTask> tasks) {
        return (PairFunction & Serializable)tuple -> {
            Atlas atlas;
            Time start = Time.now();
            try {
                AtlasLoadingOption atlasLoadingOption = AtlasGeneratorHelper.buildAtlasLoadingOption(boundaries, sparkContext, loadingOptions);
                String countryShardString = (String)tuple._1();
                CountryShard countryShard = CountryShard.forName(countryShardString);
                String country = countryShard.getCountry();
                Set<Shard> possibleShards = AtlasGeneratorHelper.getAllShardsForCountry(tasks, country);
                HadoopAtlasFileCache atlasCache = new HadoopAtlasFileCache(slicedRawAtlasPath, sparkContext);
                Function<Shard, Optional<Atlas>> slicedRawAtlasFetcher = AtlasGeneratorHelper.atlasFetcher(atlasCache, country, possibleShards);
                atlas = new WaySectionProcessor(countryShard.getShard(), atlasLoadingOption, sharding, slicedRawAtlasFetcher).run();
            }
            catch (Throwable e) {
                throw new CoreException("Sectioning Raw Atlas for {} failed!", tuple._1(), e);
            }
            logger.info("Finished sectioning raw Atlas for {} in {}", tuple._1(), (Object)start.elapsedSince());
            logger.info("Printing memory after loading final Atlas for {}", tuple._1());
            Memory.printCurrentMemory();
            Tuple2 result = new Tuple2(tuple._1(), (Object)atlas);
            return result;
        };
    }

    protected static PairFunction<Tuple2<String, Atlas>, String, Atlas> sliceRawAtlas(CountryBoundaryMap boundaries) {
        return (PairFunction & Serializable)tuple -> {
            Atlas slicedAtlas;
            String shardName = (String)tuple._1();
            Atlas rawAtlas = (Atlas)tuple._2();
            logger.info("Starting slicing raw Atlas {}", (Object)rawAtlas.getName());
            Time start = Time.now();
            try {
                String countryName = shardName.split("_")[0];
                if (countryName != null) {
                    slicedAtlas = new RawAtlasCountrySlicer(countryName, boundaries).slice(rawAtlas);
                } else {
                    slicedAtlas = null;
                    logger.error("Unable to extract valid country code for {}", (Object)shardName);
                }
            }
            catch (Throwable e) {
                throw new CoreException("Slicing raw Atlas failed for {}", shardName, e);
            }
            logger.info("Finished slicing raw Atlas for {} in {}", (Object)shardName, (Object)start.elapsedSince());
            logger.info("Printing memory after loading sliced raw Atlas for {}", (Object)shardName);
            Memory.printCurrentMemory();
            Tuple2 result = new Tuple2(tuple._1(), (Object)slicedAtlas);
            return result;
        };
    }

    private static Set<Shard> getAllShardsForCountry(List<AtlasGenerationTask> tasks, String country) {
        for (AtlasGenerationTask task : tasks) {
            if (!task.getCountry().equals(country)) continue;
            return task.getAllShards();
        }
        logger.debug("Could not find shards for {}", (Object)country);
        return Collections.emptySet();
    }

    private AtlasGeneratorHelper() {
    }
}

