/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.checks.validation.linear.edges;

import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.openstreetmap.atlas.checks.base.BaseCheck;
import org.openstreetmap.atlas.checks.flag.CheckFlag;
import org.openstreetmap.atlas.geography.atlas.items.AtlasObject;
import org.openstreetmap.atlas.geography.atlas.items.Edge;
import org.openstreetmap.atlas.tags.HighwayTag;
import org.openstreetmap.atlas.tags.JunctionTag;
import org.openstreetmap.atlas.utilities.configuration.Configuration;

public class RoundaboutValenceCheck
extends BaseCheck {
    private static final long serialVersionUID = 1L;
    public static final String WRONG_VALENCE_INSTRUCTIONS = "This roundabout, {0,number,#}, has the wrong valence. It has a valence of {1,number,#}.";
    public static final String VALENCE_OF_ONE_INSTRUCTIONS = "This feature, {0,number,#}, should not be labelled as a roundabout. This feature should be a turning loop or turning circle.";
    private static final List<String> FALLBACK_INSTRUCTIONS = Arrays.asList("This roundabout, {0,number,#}, has the wrong valence. It has a valence of {1,number,#}.", "This feature, {0,number,#}, should not be labelled as a roundabout. This feature should be a turning loop or turning circle.");
    private static final double LOWER_VALENCE_THRESHOLD_DEFAULT = 2.0;
    private static final double UPPER_VALENCE_THRESHOLD_DEFAULT = 10.0;
    private final double minimumValence;
    private final double maximumValence;

    @Override
    protected List<String> getFallbackInstructions() {
        return FALLBACK_INSTRUCTIONS;
    }

    public RoundaboutValenceCheck(Configuration configuration) {
        super(configuration);
        this.minimumValence = this.configurationValue(configuration, "connections.minimum", 2.0);
        this.maximumValence = this.configurationValue(configuration, "connections.maximum", 10.0);
    }

    @Override
    public boolean validCheckForObject(AtlasObject object) {
        return object instanceof Edge && JunctionTag.isRoundabout(object) && !this.isFlagged(object.getIdentifier()) && ((Edge)object).isMasterEdge();
    }

    @Override
    protected Optional<CheckFlag> flag(AtlasObject object) {
        Edge edge = (Edge)object;
        Set<AtlasObject> roundaboutEdges = this.getAllRoundaboutEdges(edge);
        Set connectedEdges = roundaboutEdges.stream().flatMap(roundaboutEdge -> roundaboutEdge.connectedEdges().stream()).filter(HighwayTag::isCarNavigableHighway).filter(Edge::isMasterEdge).filter(currentEdge -> !JunctionTag.isRoundabout(currentEdge)).filter(currentEdge -> !roundaboutEdges.contains(currentEdge)).collect(Collectors.toSet());
        int totalRoundaboutValence = connectedEdges.size();
        if ((double)totalRoundaboutValence < this.minimumValence || (double)totalRoundaboutValence > this.maximumValence) {
            this.markAsFlagged(object.getIdentifier());
            if (totalRoundaboutValence == 1) {
                return Optional.of(this.createFlag(roundaboutEdges, this.getLocalizedInstruction(1, edge.getOsmIdentifier())));
            }
            return Optional.of(this.createFlag(roundaboutEdges, this.getLocalizedInstruction(0, edge.getOsmIdentifier(), totalRoundaboutValence)));
        }
        return Optional.empty();
    }

    private Set<Edge> getAllRoundaboutEdges(Edge edge) {
        HashSet<Edge> roundaboutEdges = new HashSet<Edge>();
        LinkedList<Edge> queue = new LinkedList<Edge>();
        this.markAsFlagged(edge.getIdentifier());
        queue.add(edge);
        while (!queue.isEmpty()) {
            Edge currentEdge = (Edge)queue.poll();
            roundaboutEdges.add(currentEdge);
            Set<Edge> connectedEdges = currentEdge.connectedEdges();
            for (Edge connectedEdge : connectedEdges) {
                Long edgeId = connectedEdge.getIdentifier();
                if (!JunctionTag.isRoundabout(connectedEdge) || roundaboutEdges.contains(connectedEdge)) continue;
                this.markAsFlagged(edgeId);
                queue.add(connectedEdge);
            }
        }
        return roundaboutEdges;
    }
}

