/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.checks.validation.linear.edges;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.openstreetmap.atlas.checks.base.BaseCheck;
import org.openstreetmap.atlas.checks.flag.CheckFlag;
import org.openstreetmap.atlas.geography.atlas.items.AtlasObject;
import org.openstreetmap.atlas.geography.atlas.items.Edge;
import org.openstreetmap.atlas.tags.JunctionTag;
import org.openstreetmap.atlas.utilities.configuration.Configuration;

public class MalformedRoundaboutCheck
extends BaseCheck {
    private static final long serialVersionUID = -3018101860747289836L;
    private static final String WRONG_WAY_INSTRUCTIONS = "This roundabout, {0,number,#}, is going the wrong direction, or has been improperly tagged as a roundabout.";
    private static final String MULTIDIRECTIONAL_INSTRUCTIONS = "This roundabout, {0,number,#}, is multi-directional, or the roundabout has improper angle geometry.";
    private static final List<String> LEFT_DRIVING_COUNTRIES_DEFAULT = Arrays.asList("AIA", "ATG", "AUS", "BGD", "BHS", "BMU", "BRB", "BRN", "BTN", "BWA", "CCK", "COK", "CXR", "CYM", "CYP", "DMA", "FJI", "FLK", "GBR", "GGY", "GRD", "GUY", "HKG", "IDN", "IMN", "IND", "IRL", "JAM", "JEY", "JPN", "KEN", "KIR", "KNA", "LCA", "LKA", "LSO", "MAC", "MDV", "MLT", "MOZ", "MSR", "MUS", "MWI", "MYS", "NAM", "NFK", "NIU", "NPL", "NRU", "NZL", "PAK", "PCN", "PNG", "SGP", "SGS", "SHN", "SLB", "SUR", "SWZ", "SYC", "TCA", "THA", "TKL", "TLS", "TON", "TTO", "TUV", "TZA", "UGA", "VCT", "VGB", "VIR", "WSM", "ZAF", "ZMB", "ZWE");
    private static final List<String> FALLBACK_INSTRUCTIONS = Arrays.asList("This roundabout, {0,number,#}, is going the wrong direction, or has been improperly tagged as a roundabout.", "This roundabout, {0,number,#}, is multi-directional, or the roundabout has improper angle geometry.");
    private List<String> leftDrivingCountries;

    @Override
    protected List<String> getFallbackInstructions() {
        return FALLBACK_INSTRUCTIONS;
    }

    public MalformedRoundaboutCheck(Configuration configuration) {
        super(configuration);
        this.leftDrivingCountries = this.configurationValue(configuration, "traffic.countries.left", LEFT_DRIVING_COUNTRIES_DEFAULT);
    }

    @Override
    public boolean validCheckForObject(AtlasObject object) {
        return object instanceof Edge && object.getTag("iso_country_code").isPresent() && JunctionTag.isRoundabout(object) && !this.isFlagged(object.getIdentifier()) && ((Edge)object).isMasterEdge();
    }

    @Override
    protected Optional<CheckFlag> flag(AtlasObject object) {
        Edge edge = (Edge)object;
        String isoCountryCode = edge.tag("iso_country_code").toUpperCase();
        List<Edge> roundaboutEdges = this.getAllRoundaboutEdges(edge);
        RoundaboutDirection direction = MalformedRoundaboutCheck.findRoundaboutDirection(roundaboutEdges);
        if (direction.equals((Object)RoundaboutDirection.MULTIDIRECTIONAL)) {
            return Optional.of(this.createFlag(new HashSet<AtlasObject>(roundaboutEdges), this.getLocalizedInstruction(1, edge.getOsmIdentifier())));
        }
        boolean isLeftDriving = this.leftDrivingCountries.contains(isoCountryCode);
        if (direction.equals((Object)RoundaboutDirection.CLOCKWISE) && !isLeftDriving || direction.equals((Object)RoundaboutDirection.COUNTERCLOCKWISE) && isLeftDriving) {
            return Optional.of(this.createFlag(new HashSet<AtlasObject>(roundaboutEdges), this.getLocalizedInstruction(0, edge.getOsmIdentifier())));
        }
        return Optional.empty();
    }

    private List<Edge> getAllRoundaboutEdges(Edge edge) {
        ArrayList<Edge> roundaboutEdges = new ArrayList<Edge>();
        LinkedList<Edge> queue = new LinkedList<Edge>();
        this.markAsFlagged(edge.getIdentifier());
        queue.add(edge);
        while (!queue.isEmpty()) {
            Edge currentEdge = (Edge)queue.poll();
            roundaboutEdges.add(currentEdge);
            Set<Edge> connectedEdges = currentEdge.connectedEdges();
            for (Edge connectedEdge : connectedEdges) {
                if (!JunctionTag.isRoundabout(connectedEdge) || roundaboutEdges.contains(connectedEdge)) continue;
                this.markAsFlagged(connectedEdge.getIdentifier());
                queue.add(connectedEdge);
            }
        }
        roundaboutEdges.sort(Edge::compareTo);
        return roundaboutEdges;
    }

    private static RoundaboutDirection findRoundaboutDirection(List<Edge> roundaboutEdges) {
        RoundaboutDirection directionSoFar = RoundaboutDirection.UNKNOWN;
        for (int idx = 0; idx < roundaboutEdges.size(); ++idx) {
            RoundaboutDirection direction;
            Edge edge2;
            Edge edge1 = roundaboutEdges.get(idx);
            double crossProduct = MalformedRoundaboutCheck.getCrossProduct(edge1, edge2 = roundaboutEdges.get((idx + 1) % roundaboutEdges.size()));
            RoundaboutDirection roundaboutDirection = crossProduct < 0.0 ? RoundaboutDirection.COUNTERCLOCKWISE : (direction = crossProduct > 0.0 ? RoundaboutDirection.CLOCKWISE : RoundaboutDirection.UNKNOWN);
            if (direction.equals((Object)RoundaboutDirection.UNKNOWN)) continue;
            if (directionSoFar.equals((Object)RoundaboutDirection.UNKNOWN)) {
                directionSoFar = direction;
                continue;
            }
            if (directionSoFar.equals((Object)direction)) continue;
            return RoundaboutDirection.MULTIDIRECTIONAL;
        }
        return directionSoFar;
    }

    private static Double getCrossProduct(Edge edge1, Edge edge2) {
        double node1Y = edge1.start().getLocation().getLatitude().asDegrees();
        double node1X = edge1.start().getLocation().getLongitude().asDegrees();
        double node2Y = edge1.end().getLocation().getLatitude().asDegrees();
        double node2X = edge1.end().getLocation().getLongitude().asDegrees();
        double node3Y = edge2.end().getLocation().getLatitude().asDegrees();
        double node3X = edge2.end().getLocation().getLongitude().asDegrees();
        double vector1X = node2X - node1X;
        double vector1Y = node2Y - node1Y;
        double vector2X = node2X - node3X;
        double vector2Y = node2Y - node3Y;
        return vector1X * vector2Y - vector1Y * vector2X;
    }

    public static enum RoundaboutDirection {
        CLOCKWISE,
        COUNTERCLOCKWISE,
        MULTIDIRECTIONAL,
        UNKNOWN;

    }
}

